/*
 * Decompiled with CFR 0.152.
 */
package krash220.xbob.loader.utils;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionMapping {
    private static final Map<Integer, String> mapping = ImmutableMap.builder().put((Object)11602, (Object)"1.16.2").put((Object)11700, (Object)"1.17").put((Object)11900, (Object)"1.19").put((Object)11903, (Object)"1.19.3").put((Object)12000, (Object)"1.20").put((Object)12002, (Object)"1.20.2").build();
    private static final Pattern RELEASE_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?");
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("(?:Snapshot )?(\\d+)w0?(0|[1-9]\\d*)([a-z])");

    public static int getNum(String version) {
        Matcher matcher = SNAPSHOT_PATTERN.matcher(version);
        if (matcher.matches()) {
            int year = Integer.parseInt(matcher.group(1));
            int week = Integer.parseInt(matcher.group(2));
            if (year >= 23 && week >= 12) {
                version = "1.20";
            }
            if (year >= 23 && week >= 3) {
                version = "1.19.4";
            }
            if (year == 22 && week >= 42) {
                version = "1.19.3";
            }
            if (year == 22 && week == 24) {
                version = "1.19.1";
            }
            if (year == 22 && week >= 11 && week <= 19) {
                version = "1.19";
            }
            if (year == 22 && week >= 3 && week <= 7) {
                version = "1.18.2";
            }
            if (year == 21 && week >= 37 && week <= 44) {
                version = "1.18";
            }
            if (year == 20 && week >= 45 || year == 21 && week <= 20) {
                version = "1.17";
            }
            if (year == 20 && week >= 27 && week <= 30) {
                version = "1.16.2";
            }
            if (year == 20 && week >= 6 && week <= 22) {
                version = "1.16";
            }
            if (year == 19 && week >= 34) {
                version = "1.15";
            }
            if (year == 18 && week >= 43 || year == 19 && week <= 14) {
                version = "1.14";
            }
            if (year == 18 && week >= 30 && week <= 33) {
                version = "1.13.1";
            }
            if (year == 17 && week >= 43 || year == 18 && week <= 22) {
                version = "1.13";
            }
            if (year == 17 && week == 31) {
                version = "1.12.1";
            }
            if (year == 17 && week >= 6 && week <= 18) {
                version = "1.12";
            }
            if (year == 16 && week == 50) {
                version = "1.11.1";
            }
            if (year == 16 && week >= 32 && week <= 44) {
                version = "1.11";
            }
            if (year == 16 && week >= 20 && week <= 21) {
                version = "1.10";
            }
            if (year == 16 && week >= 14 && week <= 15) {
                version = "1.9.3";
            }
            if (year == 15 && week >= 31 || year == 16 && week <= 7) {
                version = "1.9";
            }
            if (year == 14 && week >= 2 && week <= 34) {
                version = "1.8";
            }
            if (year == 13 && week >= 47 && week <= 49) {
                version = "1.7.4";
            }
            if (year == 13 && week >= 36 && week <= 43) {
                version = "1.7.2";
            }
            if (year == 13 && week >= 16 && week <= 26) {
                version = "1.6";
            }
            if (year == 13 && week >= 11 && week <= 12) {
                version = "1.5.1";
            }
            if (year == 13 && week >= 1 && week <= 10) {
                version = "1.5";
            }
            if (year == 12 && week >= 49 && week <= 50) {
                version = "1.4.6";
            }
            if (year == 12 && week >= 32 && week <= 42) {
                version = "1.4.2";
            }
            if (year == 12 && week >= 15 && week <= 30) {
                version = "1.3.1";
            }
            if (year == 12 && week >= 3 && week <= 8) {
                version = "1.2.1";
            }
            if (year == 11 && week >= 47 || year == 12 && week <= 1) {
                version = "1.1";
            }
        }
        if ((matcher = RELEASE_PATTERN.matcher(version)).matches()) {
            return Integer.parseInt(matcher.group(1)) * 10000 + Integer.parseInt(matcher.group(2)) * 100 + (matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0);
        }
        return 0;
    }

    public static String get(String version) {
        int v = VersionMapping.getNum(version);
        Optional<Map.Entry> result = mapping.entrySet().stream().filter(e -> (Integer)e.getKey() <= v).max(Comparator.comparingInt(Map.Entry::getKey));
        if (result.isPresent()) {
            return (String)result.get().getValue();
        }
        return version;
    }
}

