/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.screens;

import com.razz.decocraft.common.containers.DecomposerScreenHandler;
import com.razz.decocraft.network.DecocraftPacketHandler;
import com.razz.decocraft.network.client.CDecomposerCraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DecomposerScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    private static final ResourceLocation DECOMPOSER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)"textures/gui/sprouting_table.png");
    private static final int INVENTORY_TOP = 110;
    private static final int INVENTORY_WIDTH = 171;
    private static final int INVENTORY_HEIGHT = 29;
    private static final int CLOSE_LEFT = 93;
    private static final int CLOSE_TOP = 3;
    private static final int CLOSE_WIDTH = 11;
    private static final int CLOSE_HEIGHT = 11;
    private static final int CRAFTING_LEFT = 71;
    private static final int CRAFTING_TOP = 86;
    private static final int CRAFTING_WIDTH = 24;
    private static final int CRAFTING_HEIGHT = 11;
    private static final float CRAFTING_MAX_LENGTH = 17.0f;
    private static final float FUEL_MAX_LENGTH = 23.0f;
    private static final float CRAFTING_TIME = 40.0f;
    private static final float FUEL_MAX = 16000.0f;
    private Button currentButton = Button.NONE;

    public DecomposerScreen(AbstractContainerMenu handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
        this.imageWidth = 107;
        this.imageHeight = 110;
    }

    protected void init() {
        super.init();
    }

    protected void containerTick() {
        super.containerTick();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.blit(DECOMPOSER_TEXTURE, this.leftPos + 93, this.topPos + 3, 108, 11, 11, 11);
        guiGraphics.blit(DECOMPOSER_TEXTURE, this.leftPos + 71, this.topPos + 86, 108, 0, 24, 11);
        switch (this.currentButton.ordinal()) {
            case 2: {
                guiGraphics.blit(DECOMPOSER_TEXTURE, this.leftPos + 93, this.topPos + 3, 236, 34, 11, 11);
            }
        }
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof DecomposerScreenHandler) {
            DecomposerScreenHandler screenHandler = (DecomposerScreenHandler)abstractContainerMenu;
            if (screenHandler.crafting[0] == 1) {
                guiGraphics.blit(DECOMPOSER_TEXTURE, this.leftPos + 71, this.topPos + 86, 132, 0, 24, 11);
                int craftingProgress = (int)Math.ceil((float)screenHandler.crafting[1] / 40.0f * 17.0f);
                guiGraphics.blit(DECOMPOSER_TEXTURE, this.leftPos + 45, this.topPos + 39, 108, 95, craftingProgress, 15);
            }
            if (screenHandler.fuel[0] > 0) {
                int fuelLevel = Mth.clamp((int)((int)Math.ceil((float)screenHandler.fuel[0] / 16000.0f * 23.0f)), (int)0, (int)23);
                guiGraphics.blit(DECOMPOSER_TEXTURE, this.leftPos + 36, this.topPos + 87, 108, 83, fuelLevel, 11);
            }
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(DECOMPOSER_TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blit(DECOMPOSER_TEXTURE, this.leftPos + this.imageWidth / 2 - 85, this.topPos + 110, 0, 110, 171, 29);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void slotClicked(Slot slot, int slotId, int button, ClickType actionType) {
        if (slotId < 12) {
            super.slotClicked(slot, slotId, button, ClickType.PICKUP);
        } else {
            super.slotClicked(slot, slotId, button, actionType);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            double d0 = mouseX - (double)this.leftPos;
            double d1 = mouseY - (double)this.topPos;
            if (d0 >= 93.0 && d0 <= 104.0 && d1 >= 3.0 && d1 <= 14.0) {
                this.currentButton = Button.CLOSE;
                this.onClose();
                return true;
            }
            if (d0 >= 71.0 && d0 <= 95.0 && d1 >= 86.0 && d1 <= 97.0) {
                this.currentButton = Button.CRAFTING;
                AbstractContainerMenu abstractContainerMenu = this.menu;
                if (abstractContainerMenu instanceof DecomposerScreenHandler) {
                    DecomposerScreenHandler screenHandler = (DecomposerScreenHandler)abstractContainerMenu;
                    screenHandler.crafting[0] = screenHandler.crafting[0] == 0 ? 1 : 0;
                    DecocraftPacketHandler.sendToServer(new CDecomposerCraft(screenHandler.crafting[0]));
                }
                return true;
            }
            this.currentButton = Button.NONE;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.currentButton = Button.NONE;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private static enum Button {
        NONE,
        CRAFTING,
        CLOSE;

    }
}

