/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common;

import com.razz.decocraft.Decocraft;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.blocks.DecoAnimatedBlock;
import com.razz.decocraft.common.blocks.DecoBedBlock;
import com.razz.decocraft.common.blocks.DecoFakeBlock;
import com.razz.decocraft.common.blocks.DecoSeatBlock;
import com.razz.decocraft.common.blocks.DecoStorageBlock;
import com.razz.decocraft.common.blocks.DecoWaterBlock;
import com.razz.decocraft.common.blocks.DecobenchBlock;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.blocks.DecomposerBlock;
import com.razz.decocraft.common.items.DecoBlockItem;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelLoader;
import com.razz.decocraft.utils.JsonParser;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.RegisterEvent;

public class ModuleBlocks {
    public static Map<String, Block> DECOBLOCKS = Collections.synchronizedMap(new HashMap());
    public static final List<Block> DECOBLOCKS_TABS = new ArrayList<Block>();
    public static final Map<String, List<Block>> BLOCKS_PER_GROUP = Collections.synchronizedMap(new HashMap());
    public static Block[] SCRIPT_FLIPBOOK_TE_NEEDED = new Block[0];
    public static Block[] ANIMATED_TE_NEEDED = new Block[0];
    public static Block[] STORAGE_TE_NEEDED = new Block[0];
    public static Block[] DECOBENCH_TE_NEEDED = new Block[0];
    public static Block[] DECOMPOSER_TE_NEEDED = new Block[0];
    public static Map<String, BBModel> MAT_TO_BB_MODEL = Collections.synchronizedMap(new HashMap());
    public static Map<String, JsonContainer.Entry> MAT_TO_ENTRY = Collections.synchronizedMap(new HashMap());
    public static Map<String, String> MATERIAL_TO_DECOREF = Collections.synchronizedMap(new HashMap());
    public static Block DECOFAKE;
    private static final ConcurrentHashMap<String, BBModel> MODEL_CACHE;
    private static final int BATCH_SIZE = 50;
    private static List<Block> scriptTeNeeded;
    private static List<Block> animatedTeNeeded;
    private static List<Block> storageTeNeeded;
    private static List<Block> decobenchTeNeeded;
    private static List<Block> decomposerTeNeeded;
    private static boolean initialized;
    private static RegisterEvent currentRegisterEvent;

    public static void initialize(RegisterEvent event) {
        if (initialized) {
            Decocraft.LOGGER.info("ModuleBlocks already initialized, skipping");
            return;
        }
        initialized = true;
        currentRegisterEvent = event;
        Decocraft.LOGGER.info("Starting Decocraft block registration...");
        ModuleBlocks.registerDynamicBlocks();
        currentRegisterEvent = null;
    }

    public static void registerBlockItems(RegisterEvent event) {
        Decocraft.LOGGER.info("Starting BlockItem registration for {} blocks...", (Object)DECOBLOCKS.size());
        int registered = 0;
        int skipped = 0;
        for (Map.Entry<String, Block> entry : DECOBLOCKS.entrySet()) {
            String uniqueId = entry.getKey();
            Block block = entry.getValue();
            if (block instanceof DecocraftBlock) {
                DecocraftBlock decoBlock = (DecocraftBlock)block;
                if (decoBlock.meta.hidden) {
                    Decocraft.LOGGER.debug("Skipping BlockItem registration for hidden block: {}", (Object)uniqueId);
                    ++skipped;
                    continue;
                }
            }
            try {
                DecoBlockItem blockItem = new DecoBlockItem(block, new Item.Properties());
                event.register(Registries.ITEM, ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)uniqueId), () -> blockItem);
                if (uniqueId.contains("locker_red")) {
                    Decocraft.LOGGER.info("Registered BlockItem: {} -> block: {}", (Object)uniqueId, (Object)block.getClass().getSimpleName());
                }
                ++registered;
            }
            catch (Exception e) {
                Decocraft.LOGGER.error("Failed to register BlockItem for {}: {}", (Object)uniqueId, (Object)e.getMessage());
            }
        }
        Decocraft.LOGGER.info("Registered {} BlockItems successfully, skipped {} hidden blocks", (Object)registered, (Object)skipped);
    }

    private static void registerDynamicBlocks() {
        try {
            ModuleBlocks.loadBlocksFromResources();
        }
        catch (Exception e) {
            Decocraft.LOGGER.error("Failed to load dynamic blocks: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void loadBlocksFromResources() {
        List<JsonContainer.Entry> blockEntries = ModuleBlocks.loadFromCentralizedRegistry();
        Decocraft.LOGGER.info("Starting batched async model loading for {} entries...", (Object)blockEntries.size());
        long startTime = System.currentTimeMillis();
        ModuleBlocks.loadModelsInBatches(blockEntries);
        long modelLoadTime = System.currentTimeMillis();
        Decocraft.LOGGER.info("Model loading completed in {}ms", (Object)(modelLoadTime - startTime));
        for (JsonContainer.Entry entry : blockEntries) {
            ModuleBlocks.registerDynamicBlockWithCachedModel(entry);
        }
        SCRIPT_FLIPBOOK_TE_NEEDED = scriptTeNeeded.toArray(new Block[0]);
        ANIMATED_TE_NEEDED = animatedTeNeeded.toArray(new Block[0]);
        STORAGE_TE_NEEDED = storageTeNeeded.toArray(new Block[0]);
        DECOBENCH_TE_NEEDED = decobenchTeNeeded.toArray(new Block[0]);
        DECOMPOSER_TE_NEEDED = decomposerTeNeeded.toArray(new Block[0]);
        long totalTime = System.currentTimeMillis();
        Decocraft.LOGGER.info("Decocraft block registration complete - processed {} entries in {}ms", (Object)blockEntries.size(), (Object)(totalTime - startTime));
    }

    private static List<JsonContainer.Entry> loadFromCentralizedRegistry() {
        ArrayList<JsonContainer.Entry> entries = new ArrayList<JsonContainer.Entry>();
        ArrayList<JsonContainer.Entry> boundingBoxes = new ArrayList<JsonContainer.Entry>();
        try {
            String registryPath = "assets/decocraft_nature/decocraft.json";
            String[] paths = JsonParser.parseFiles(registryPath);
            if (paths != null) {
                for (String path : paths) {
                    try {
                        String fullPath = "assets/decocraft_nature/" + path;
                        JsonContainer container = JsonParser.parseDecocraft(fullPath);
                        if (container.models != null) {
                            entries.addAll(Arrays.asList(container.models));
                        }
                        if (container.bounding_boxes == null) continue;
                        boundingBoxes.addAll(Arrays.asList(container.bounding_boxes));
                    }
                    catch (Exception e) {
                        Decocraft.LOGGER.error("Failed to load JSON file: {} - {}", new Object[]{path, e.getMessage(), e});
                    }
                }
            }
        }
        catch (Exception e) {
            Decocraft.LOGGER.error("Failed to load centralized registry: {}", (Object)e.getMessage(), (Object)e);
        }
        ModuleBlocks.readBoundingBoxes(boundingBoxes);
        return entries;
    }

    private static void loadModelsInBatches(List<JsonContainer.Entry> blockEntries) {
        Set uniqueModels = blockEntries.stream().map(entry -> entry.model).filter(Objects::nonNull).collect(Collectors.toSet());
        ArrayList modelNames = new ArrayList(uniqueModels);
        Decocraft.LOGGER.info("Loading {} unique models in batches of {}", (Object)modelNames.size(), (Object)50);
        for (int i = 0; i < modelNames.size(); i += 50) {
            int endIndex = Math.min(i + 50, modelNames.size());
            List batch = modelNames.subList(i, endIndex);
            Decocraft.LOGGER.info("Loading batch {}/{} ({} models)", new Object[]{i / 50 + 1, (modelNames.size() + 50 - 1) / 50, batch.size()});
            List<CompletableFuture> batchFutures = batch.stream().map(modelName -> CompletableFuture.runAsync(() -> {
                try {
                    BBModel model = ModuleBlocks.loadBBModelFromFile(modelName);
                    if (model != null) {
                        MODEL_CACHE.put((String)modelName, model);
                    }
                }
                catch (Exception e) {
                    Decocraft.LOGGER.error("Failed to load model {} in batch: {}", modelName, (Object)e.getMessage());
                }
            }, ForkJoinPool.commonPool())).collect(Collectors.toList());
            CompletableFuture<Void> batchCompletion = CompletableFuture.allOf(batchFutures.toArray(new CompletableFuture[0]));
            try {
                batchCompletion.join();
                continue;
            }
            catch (Exception e) {
                Decocraft.LOGGER.error("Error completing model loading batch: {}", (Object)e.getMessage());
            }
        }
        Decocraft.LOGGER.info("Successfully cached {} models", (Object)MODEL_CACHE.size());
    }

    private static void registerDynamicBlockWithCachedModel(JsonContainer.Entry entry) {
        try {
            String uniqueId;
            BBModel model;
            if (entry == null || entry.material == null || entry.material.trim().isEmpty()) {
                return;
            }
            if (entry.material != null && entry.material.contains("flipbook")) {
                Decocraft.LOGGER.info(">>> FLIPBOOK BLOCK: material={}, model={}, decoref={}, hasFlipbook={}", new Object[]{entry.material, entry.model, entry.decoref, entry.flipbook != null && entry.flipbook.images > 0});
            }
            if ((model = MODEL_CACHE.get(entry.model)) == null) {
                Decocraft.LOGGER.error("Model not found in cache: {} for entry: {}", (Object)entry.model, (Object)entry.material);
                return;
            }
            String string = uniqueId = entry.decoref != null ? entry.decoref : entry.material;
            if (uniqueId == null || uniqueId.trim().isEmpty()) {
                return;
            }
            if ("air".equals(uniqueId) || "minecraft:air".equals(uniqueId)) {
                return;
            }
            if (entry.material != null && entry.material.contains("flipbook")) {
                Decocraft.LOGGER.info(">>> FLIPBOOK BLOCK REGISTERING: uniqueId={}", (Object)uniqueId);
            }
            if (entry.script != null && entry.script.light > 0) {
                entry.lighting = entry.script.light;
            }
            MAT_TO_BB_MODEL.put(uniqueId, model);
            MAT_TO_ENTRY.put(uniqueId, entry);
            if (entry.material != null && !entry.material.isEmpty()) {
                MATERIAL_TO_DECOREF.put(entry.material, uniqueId);
            }
            Block block = ModuleBlocks.createBlock(entry, model);
            if (currentRegisterEvent == null) {
                Decocraft.LOGGER.error("Attempted to register block {} but RegisterEvent is null!", (Object)uniqueId);
                return;
            }
            currentRegisterEvent.register(Registries.BLOCK, ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)uniqueId), () -> block);
            if (block == null || block == Blocks.AIR) {
                return;
            }
            DECOBLOCKS.put(uniqueId, block);
            DECOBLOCKS_TABS.add(block);
            if (!entry.hidden && !Objects.equals(entry.type, "fake_block")) {
                BLOCKS_PER_GROUP.computeIfAbsent(entry.tabs, k -> new ArrayList()).add(block);
            }
            if ("decobench".equals(uniqueId) || "decobench".equals(entry.type) || "nature_bench".equals(entry.type)) {
                decobenchTeNeeded.add(block);
            } else if ("decomposer".equals(uniqueId) || "decomposer".equals(entry.type) || "sprouting_table".equals(entry.type)) {
                decomposerTeNeeded.add(block);
            } else if (entry.script != null && entry.script.on_use != null && entry.script.on_use.storage != null && entry.script.on_use.storage.length == 2) {
                storageTeNeeded.add(block);
            } else if (Objects.equals(entry.type, "animated")) {
                animatedTeNeeded.add(block);
            } else if (entry.script != null && (entry.script.trigger != null || entry.script.on_use != null)) {
                scriptTeNeeded.add(block);
            }
        }
        catch (Exception e) {
            Decocraft.LOGGER.error("Failed to register block {}: {}", new Object[]{entry.material, e.getMessage(), e});
        }
    }

    private static BBModel loadBBModelFromFile(String modelName) {
        BBModel bBModel;
        block10: {
            ModContainer modContainer = ModList.get().getModContainerById("decocraft_nature").orElse(null);
            if (modContainer == null) {
                return null;
            }
            Path modelPath = modContainer.getModInfo().getOwningFile().getFile().findResource(new String[]{"assets/decocraft_nature/models/bbmodel/" + modelName + ".bbmodel"});
            if (!Files.exists(modelPath, new LinkOption[0])) {
                return null;
            }
            InputStream stream = Files.newInputStream(modelPath, new OpenOption[0]);
            try {
                BBModelLoader loader = new BBModelLoader();
                bBModel = loader.loadModel(stream);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Decocraft.LOGGER.error("Failed to load BBModel {}: {}", (Object)modelName, (Object)e.getMessage());
                    return null;
                }
            }
            stream.close();
        }
        return bBModel;
    }

    private static void readBoundingBoxes(List<JsonContainer.Entry> boundingBoxes) {
        try {
            for (JsonContainer.Entry meta : boundingBoxes) {
                BBModel model = JsonParser.parseModel("assets/decocraft_nature/bounding_boxes/bbmodel/" + meta.model + ".bbmodel");
                String key = meta.material != null ? meta.material : meta.model;
                MAT_TO_BB_MODEL.put(key, model);
            }
        }
        catch (Exception e) {
            Decocraft.LOGGER.error("Failed to read bounding boxes: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static Block createBlock(JsonContainer.Entry meta, BBModel model) {
        try {
            String uniqueId;
            String string = uniqueId = meta.decoref != null ? meta.decoref : meta.material;
            if ("decobench".equals(uniqueId)) {
                return new DecobenchBlock(meta, model);
            }
            if ("decomposer".equals(uniqueId)) {
                return new DecomposerBlock(meta, model);
            }
            if (meta.script != null && meta.script.on_use != null && meta.script.on_use.storage != null && meta.script.on_use.storage.length == 2) {
                return new DecoStorageBlock(meta, model);
            }
            if (meta.type != null) {
                switch (meta.type) {
                    case "bed": {
                        return new DecoBedBlock(meta, model);
                    }
                    case "seat": {
                        return new DecoSeatBlock(meta, model);
                    }
                    case "animated": {
                        return new DecoAnimatedBlock(meta, model);
                    }
                    case "water": {
                        return new DecoWaterBlock(meta, model);
                    }
                    case "decobench": {
                        return new DecobenchBlock(meta, model);
                    }
                    case "nature_bench": {
                        return new DecobenchBlock(meta, model);
                    }
                    case "decomposer": {
                        return new DecomposerBlock(meta, model);
                    }
                    case "sprouting_table": {
                        return new DecomposerBlock(meta, model);
                    }
                    case "fake_block": {
                        return new DecoFakeBlock(meta, model);
                    }
                }
            }
            return new DecocraftBlock(meta, model);
        }
        catch (Exception e) {
            Decocraft.LOGGER.error("Error creating block for {}: {}", new Object[]{meta.decoref != null ? meta.decoref : meta.material, e.getMessage(), e});
            return null;
        }
    }

    static {
        MODEL_CACHE = new ConcurrentHashMap();
        scriptTeNeeded = new ArrayList<Block>();
        animatedTeNeeded = new ArrayList<Block>();
        storageTeNeeded = new ArrayList<Block>();
        decobenchTeNeeded = new ArrayList<Block>();
        decomposerTeNeeded = new ArrayList<Block>();
        initialized = false;
        currentRegisterEvent = null;
    }
}

