/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.containers;

import com.razz.decocraft.common.ModuleScreenHandlers;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DecoStorageScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final int rows;
    private final int cols;

    public DecoStorageScreenHandler(int syncId, Inventory playerInventory, Container inventory, int width, int height) {
        super((MenuType)ModuleScreenHandlers.DECO_STORAGE.get(), syncId);
        int col;
        DecoStorageScreenHandler.checkContainerSize((Container)inventory, (int)(width * height));
        this.inventory = inventory;
        this.cols = width;
        this.rows = height;
        inventory.startOpen(playerInventory.player);
        int guiWidth = Math.max(176, 7 + this.cols * 18 + 7);
        int xOffset = (guiWidth - (7 + this.cols * 18 + 7)) / 2;
        int slotX = xOffset + 8;
        int slotY = 26;
        for (int row = 0; row < this.rows; ++row) {
            for (col = 0; col < this.cols; ++col) {
                this.addSlot(new Slot(inventory, col + row * this.cols, slotX + col * 18, slotY + row * 18));
            }
        }
        int playerY = 8 + (17 + this.rows * 18 + 1) + 7;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.addSlot(new Slot((Container)playerInventory, col2 + (row + 1) * 9, 8 + col2 * 18, playerY + 17 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, playerY + 75));
        }
    }

    public DecoStorageScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(27), 9, 3);
    }

    public DecoStorageScreenHandler(int syncId, Inventory playerInventory, int width, int height) {
        this(syncId, playerInventory, (Container)new SimpleContainer(width * height), width, height);
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot == null || !slot.hasItem()) {
            return newStack;
        }
        ItemStack stack = slot.getItem();
        newStack = stack.copy();
        int size = this.cols * this.rows;
        if (invSlot < size ? !this.moveItemStackTo(stack, size, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, size, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }
}

