/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.groups;

import com.razz.decocraft.Decocraft;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleItems;
import com.razz.decocraft.common.groups.DecocraftGroup;
import com.razz.decocraft.utils.MapUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

public class GroupSelector {
    public static final Map<String, DecocraftGroup> SELECT = new HashMap<String, DecocraftGroup>();
    public static final Map<String, DeferredHolder<CreativeModeTab, CreativeModeTab>> TABS = new HashMap<String, DeferredHolder<CreativeModeTab, CreativeModeTab>>();

    public static void registerCreativeTabs(RegisterEvent event) {
        if (ModuleBlocks.DECOBLOCKS.isEmpty()) {
            System.err.println("WARNING: Attempting to register creative tabs before blocks are loaded!");
        }
        for (Map.Entry<String, DecocraftGroup> entry : MapUtil.sortByKey(SELECT).entrySet()) {
            String key = entry.getKey();
            DecocraftGroup group = entry.getValue();
            event.register(Registries.CREATIVE_MODE_TAB, ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)key), () -> CreativeModeTab.builder().icon(() -> {
                Block iconBlock = ModuleBlocks.DECOBLOCKS.get(group.icon());
                if (iconBlock != null) {
                    try {
                        Field metaField = null;
                        Class<?> currentClass = iconBlock.getClass();
                        while (currentClass != null && metaField == null) {
                            try {
                                metaField = currentClass.getDeclaredField("meta");
                            }
                            catch (NoSuchFieldException e) {
                                currentClass = currentClass.getSuperclass();
                            }
                        }
                        if (metaField != null) {
                            metaField.setAccessible(true);
                            Object metaObj = metaField.get(iconBlock);
                            if (metaObj instanceof JsonContainer.Entry) {
                                Item item;
                                ResourceLocation identifier;
                                String itemId;
                                JsonContainer.Entry meta = (JsonContainer.Entry)metaObj;
                                String string = itemId = meta.decoref != null ? meta.decoref : meta.material;
                                if (itemId != null && BuiltInRegistries.ITEM.containsKey(identifier = ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)itemId)) && (item = (Item)BuiltInRegistries.ITEM.get(identifier)) != null && !item.equals(Items.AIR)) {
                                    return new ItemStack((ItemLike)item);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return new ItemStack((ItemLike)iconBlock);
                }
                return new ItemStack((ItemLike)Items.STONE);
            }).title((Component)Component.translatable((String)("itemGroup." + group.label()))).displayItems((parameters, output) -> {
                Decocraft.LOGGER.info("Building creative tab '{}' with {} total blocks in DECOBLOCKS_TABS", (Object)key, (Object)ModuleBlocks.DECOBLOCKS_TABS.size());
                int[] matchCount = new int[]{0};
                int[] addedCount = new int[]{0};
                ModuleBlocks.DECOBLOCKS_TABS.stream().filter(f -> {
                    try {
                        Field metaField = null;
                        Class<?> currentClass = f.getClass();
                        while (currentClass != null && metaField == null) {
                            try {
                                metaField = currentClass.getDeclaredField("meta");
                            }
                            catch (NoSuchFieldException e) {
                                currentClass = currentClass.getSuperclass();
                            }
                        }
                        if (metaField == null) {
                            return "all".equals(key);
                        }
                        metaField.setAccessible(true);
                        Object metaObj = metaField.get(f);
                        if (metaObj instanceof JsonContainer.Entry) {
                            boolean matches;
                            JsonContainer.Entry meta = (JsonContainer.Entry)metaObj;
                            boolean bl = matches = !meta.hidden && Objects.equals(meta.tabs, key);
                            if (matches) {
                                matchCount[0] = matchCount[0] + 1;
                            }
                            return matches;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return "all".equals(key);
                }).forEach(f -> {
                    try {
                        Field metaField = null;
                        Class<?> currentClass = f.getClass();
                        while (currentClass != null && metaField == null) {
                            try {
                                metaField = currentClass.getDeclaredField("meta");
                            }
                            catch (NoSuchFieldException e) {
                                currentClass = currentClass.getSuperclass();
                            }
                        }
                        if (metaField == null) {
                            return;
                        }
                        metaField.setAccessible(true);
                        Object metaObj = metaField.get(f);
                        if (metaObj instanceof JsonContainer.Entry) {
                            Item item;
                            ResourceLocation identifier;
                            String itemId;
                            JsonContainer.Entry meta = (JsonContainer.Entry)metaObj;
                            String string = itemId = meta.decoref != null ? meta.decoref : meta.material;
                            if (itemId != null && BuiltInRegistries.ITEM.containsKey(identifier = ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)itemId)) && (item = (Item)BuiltInRegistries.ITEM.get(identifier)) != null && !item.equals(Items.AIR)) {
                                output.accept(new ItemStack((ItemLike)item));
                                addedCount[0] = addedCount[0] + 1;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                Decocraft.LOGGER.info("Tab '{}': {} blocks matched filter, {} items added to tab", new Object[]{key, matchCount[0], addedCount[0]});
                if (key.equals("crafting")) {
                    output.accept(new ItemStack((ItemLike)ModuleItems.RAW_MATERIAL.get()));
                    if (ModuleItems.DECOBRUSH != null) {
                        output.accept(new ItemStack((ItemLike)ModuleItems.DECOBRUSH.get()));
                    }
                }
            }).build());
        }
    }

    static {
        if (Objects.equals("decocraft_nature", "decocraft")) {
            SELECT.put("bathroom", new DecocraftGroup("decocraft.bathroom", "toilet_white"));
            SELECT.put("clutter", new DecocraftGroup("decocraft.clutter", "coin_pile_gold"));
            SELECT.put("comfort", new DecocraftGroup("decocraft.comfort", "rocking_chair_oak"));
            SELECT.put("crafting", new DecocraftGroup("decocraft.crafting", "decobench"));
            SELECT.put("flags", new DecocraftGroup("decocraft.flags", "mexico"));
            SELECT.put("food", new DecocraftGroup("decocraft.food", "bowl_of_cereal_minecraft"));
            SELECT.put("hobby", new DecocraftGroup("decocraft.hobby", "spinning_wheel"));
            SELECT.put("kitchen", new DecocraftGroup("decocraft.kitchen", "toaster_silver"));
            SELECT.put("laundry", new DecocraftGroup("decocraft.laundry", "washer"));
            SELECT.put("lighting", new DecocraftGroup("decocraft.lighting", "stained_glass_table_lamp_popsicle"));
            SELECT.put("medieval", new DecocraftGroup("decocraft.medieval", "medieval_high_canopy_bed_queen_red"));
            SELECT.put("patreon", new DecocraftGroup("decocraft.patreon", "000_dpop_razz"));
            SELECT.put("pets", new DecocraftGroup("decocraft.pets", "cat_tree"));
            SELECT.put("seasonal", new DecocraftGroup("decocraft.seasonal", "papel_picado_white"));
            SELECT.put("shops", new DecocraftGroup("decocraft.shops", "clothes_rack_4"));
            SELECT.put("signs", new DecocraftGroup("decocraft.signs", "hanging_apothecary"));
            SELECT.put("storage", new DecocraftGroup("decocraft.storage", "barrel"));
            SELECT.put("surface", new DecocraftGroup("decocraft.surface", "wooden_table_oak"));
            SELECT.put("tech", new DecocraftGroup("decocraft.tech", "atm"));
            SELECT.put("toys", new DecocraftGroup("decocraft.toys", "stuffed_creeper"));
            SELECT.put("wall_decor", new DecocraftGroup("decocraft.wall_decor", "empire_strikes_back"));
        } else if (Objects.equals("decocraft_nature", "decocraft_nature")) {
            SELECT.put("crafting", new DecocraftGroup("decocraft_nature.crafting", "nature_bench"));
            SELECT.put("ground_cover", new DecocraftGroup("decocraft_nature.ground_cover", "clovers_1"));
            SELECT.put("climbing_plants", new DecocraftGroup("decocraft_nature.climbing_plants", "ivy_wall_full"));
            SELECT.put("other_plants", new DecocraftGroup("decocraft_nature.other_plants", "venus_flytrap"));
            SELECT.put("flowers", new DecocraftGroup("decocraft_nature.flowers", "foxglove_group_pink"));
            SELECT.put("trees", new DecocraftGroup("decocraft_nature.trees", "log_broken_oak"));
            SELECT.put("potted_plants", new DecocraftGroup("decocraft_nature.potted_plants", "potted_calathea"));
            SELECT.put("cacti_succulents", new DecocraftGroup("decocraft_nature.cacti_succulents", "nopal_3"));
            SELECT.put("fungi", new DecocraftGroup("decocraft_nature.fungi", "fly_agaric_2"));
            SELECT.put("aquatic_plants", new DecocraftGroup("decocraft_nature.aquatic_plants", "lotus_flower"));
            SELECT.put("garden_decor", new DecocraftGroup("decocraft_nature.garden_decor", "bird_house_3"));
        }
    }
}

