/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface ImplementedInventory
extends Container {
    public NonNullList<ItemStack> getItems();

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    default public ItemStack removeItem(int slot, int count) {
        ItemStack result;
        ItemStack stack = this.getItem(slot);
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (stack.getCount() <= count) {
            result = stack;
            this.setItem(slot, ItemStack.EMPTY);
        } else {
            result = stack.split(count);
            if (stack.isEmpty()) {
                this.setItem(slot, ItemStack.EMPTY);
            }
        }
        this.setChanged();
        return result;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        ItemStack result = this.getItem(slot);
        this.setItem(slot, ItemStack.EMPTY);
        return result;
    }

    default public void setItem(int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            System.out.println("ImplementedInventory: setItem(" + slot + ", EMPTY) called!");
        } else {
            System.out.println("ImplementedInventory: setItem(" + slot + ", " + String.valueOf(stack.getItem()) + " x" + stack.getCount() + ") called!");
        }
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    default public void clearContent() {
        System.out.println("ImplementedInventory: clearContent() called!");
        this.getItems().clear();
        this.setChanged();
    }

    default public void setChanged() {
    }

    default public boolean stillValid(Player player) {
        return true;
    }
}

