/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import com.razz.decocraft.models.bbmodel.BlockbenchModel;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.Nullable;

public class BBUnbakedModel
implements UnbakedModel {
    private final String materialName;
    private final BBModel bbModel;

    public BBUnbakedModel(String materialName, BBModel bbModel) {
        this.materialName = materialName;
        this.bbModel = bbModel;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptySet();
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter) {
    }

    @Nullable
    public BakedModel bake(ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState rotationContainer) {
        String textureToUse = this.materialName;
        if (ModuleBlocks.MAT_TO_ENTRY.containsKey(this.materialName)) {
            JsonContainer.Entry entry = ModuleBlocks.MAT_TO_ENTRY.get(this.materialName);
            textureToUse = entry.material;
        }
        String finalTexture = textureToUse;
        Function<ResourceLocation, TextureAtlasSprite> spriteLookup = id -> {
            try {
                String simplePath;
                Material material = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("block/" + id.getPath())));
                TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(material);
                if (sprite != null) {
                    return sprite;
                }
                material = new Material(InventoryMenu.BLOCK_ATLAS, id);
                sprite = (TextureAtlasSprite)spriteGetter.apply(material);
                if (sprite != null) {
                    return sprite;
                }
                if (!id.getNamespace().equals("decocraft_nature") && (sprite = (TextureAtlasSprite)spriteGetter.apply(material = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)("block/" + id.getPath()))))) != null) {
                    return sprite;
                }
                if (id.getPath().contains("/") && (sprite = (TextureAtlasSprite)spriteGetter.apply(material = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)("block/" + (simplePath = id.getPath().substring(id.getPath().lastIndexOf("/") + 1))))))) != null) {
                    return sprite;
                }
                material = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"missingno"));
                return (TextureAtlasSprite)spriteGetter.apply(material);
            }
            catch (Exception e) {
                Material material = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"missingno"));
                return (TextureAtlasSprite)spriteGetter.apply(material);
            }
        };
        Object texturePath = finalTexture;
        if (texturePath != null && !((String)texturePath).contains(":")) {
            texturePath = "decocraft_nature:" + (String)texturePath;
        } else if (texturePath == null) {
            texturePath = "decocraft_nature:missingno";
        }
        float scale = 1.0f;
        if (ModuleBlocks.MAT_TO_ENTRY.containsKey(this.materialName)) {
            JsonContainer.Entry entry = ModuleBlocks.MAT_TO_ENTRY.get(this.materialName);
            if (entry.scale > 0.0f) {
                scale = entry.scale;
            }
        }
        BlockbenchLoader.BlockbenchSetting settings = new BlockbenchLoader.BlockbenchSetting(ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)this.materialName), scale, false, (String)texturePath);
        return new BlockbenchModel(settings, this.bbModel, spriteLookup, rotationContainer);
    }
}

