/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network.client;

import com.razz.decocraft.common.containers.DecobenchScreenHandler;
import com.razz.decocraft.common.tileentities.DecobenchTileEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CDecobenchClick(ItemStack itemStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CDecobenchClick> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)"decobench_click"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CDecobenchClick> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, CDecobenchClick::itemStack, CDecobenchClick::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CDecobenchClick payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            AbstractContainerMenu screenHandler = player.containerMenu;
            if (!(screenHandler instanceof DecobenchScreenHandler)) {
                return;
            }
            DecobenchScreenHandler decobench = (DecobenchScreenHandler)screenHandler;
            decobench.getContext().execute((world, blockPos) -> {
                BlockEntity patt0$temp = world.getBlockEntity(blockPos);
                if (patt0$temp instanceof DecobenchTileEntity) {
                    DecobenchTileEntity tileEntity = (DecobenchTileEntity)patt0$temp;
                    tileEntity.setPendingCrafting(payload.itemStack);
                }
            });
        });
    }
}

