/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network.client;

import com.razz.decocraft.common.containers.DecobenchScreenHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CDecobenchCraft(int craft) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CDecobenchCraft> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)"decobench_craft"));
    public static final StreamCodec<ByteBuf, CDecobenchCraft> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CDecobenchCraft::craft, CDecobenchCraft::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CDecobenchCraft payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            System.out.println("SERVER: Received craft packet with value: " + payload.craft);
            if (player == null) {
                System.out.println("SERVER: Player is null!");
                return;
            }
            AbstractContainerMenu screenHandler = player.containerMenu;
            if (!(screenHandler instanceof DecobenchScreenHandler)) {
                System.out.println("SERVER: Wrong screen handler type: " + String.valueOf(screenHandler.getClass()));
                return;
            }
            DecobenchScreenHandler decobench = (DecobenchScreenHandler)screenHandler;
            System.out.println("SERVER: Calling craft(" + payload.craft + ") on screen handler");
            decobench.craft(payload.craft);
        });
    }
}

