/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network.client;

import com.razz.decocraft.common.containers.DecobenchScreenHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CDecobenchSearch(String searchText) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CDecobenchSearch> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)"decobench_search"));
    public static final StreamCodec<ByteBuf, CDecobenchSearch> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CDecobenchSearch::searchText, CDecobenchSearch::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CDecobenchSearch payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            AbstractContainerMenu screenHandler = player.containerMenu;
            if (!(screenHandler instanceof DecobenchScreenHandler)) {
                return;
            }
            DecobenchScreenHandler decobench = (DecobenchScreenHandler)screenHandler;
            decobench.search(payload.searchText);
        });
    }
}

