/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network.client;

import com.razz.decocraft.common.containers.DecomposerScreenHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CDecomposerCraft(int craft) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CDecomposerCraft> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)"decomposer_craft"));
    public static final StreamCodec<ByteBuf, CDecomposerCraft> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CDecomposerCraft::craft, CDecomposerCraft::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CDecomposerCraft payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            AbstractContainerMenu screenHandler = player.containerMenu;
            if (!(screenHandler instanceof DecomposerScreenHandler)) {
                return;
            }
            DecomposerScreenHandler decomposer = (DecomposerScreenHandler)screenHandler;
            decomposer.craft(payload.craft);
        });
    }
}

