/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.models.bbmodel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.razz.decocraft_nature.models.bbmodel.BBModel;
import com.razz.decocraft_nature.models.bbmodel.BBModelParts;
import com.razz.decocraft_nature.models.libgdx.Vector3;
import com.razz.decocraft_nature.utils.exp4j.ExpressionBuilder;
import java.awt.image.BufferedImage;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;

public class BBModelLoader {
    private static final Gson gson;

    public static void main(String[] args) {
        BBModel bbmodel = new BBModelLoader().loadModel("src/main/resources/assets/decocraft/models/tmp/portable_record_player.bbmodel");
        System.out.println(bbmodel.elements.get(0));
    }

    public BBModel loadModel(String path) {
        block8: {
            BBModel bBModel;
            FileReader reader = new FileReader(path);
            try {
                bBModel = this.loadModel(reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (Exception e) {
                    System.out.println(path);
                    e.printStackTrace();
                }
            }
            ((Reader)reader).close();
            return bBModel;
        }
        return null;
    }

    public BBModel loadModel(InputStream path) {
        BBModel bBModel;
        InputStreamReader reader = new InputStreamReader(path);
        try {
            bBModel = this.loadModel(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        ((Reader)reader).close();
        return bBModel;
    }

    public BBModel loadModel(Reader reader) {
        BBModel bbmodel = (BBModel)gson.fromJson(reader, BBModel.class);
        this.parse(bbmodel);
        return bbmodel;
    }

    public BBModel loadModel(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        BBModel bbmodel = (BBModel)gson.fromJson((JsonElement)modelContents, BBModel.class);
        this.parse(bbmodel);
        return bbmodel;
    }

    private void parseOutlinerCube(@Nonnull BBModel bbmodel, @Nonnull BBModelParts.OutlinerCube cube, BBModelParts.OutlinerGroup parent) {
        bbmodel.outlinerFlatList.add(bbmodel.uuidMap.get(cube.uuid));
        if (null != parent) {
            bbmodel.uuidMap.get((Object)cube.uuid).parent = parent;
        }
    }

    private void parseOutlinerGroup(@Nonnull BBModel bbmodel, @Nonnull BBModelParts.OutlinerGroup root, BBModelParts.OutlinerGroup parent) {
        bbmodel.uuidMap.put(root.uuid, root);
        bbmodel.outlinerFlatList.add(root);
        if (null != parent) {
            root.parent = parent;
        }
        for (BBModelParts.OutlinerNode child : root.children) {
            this.parseOutliner(bbmodel, child, root);
        }
    }

    private void parseOutliner(@Nonnull BBModel bbmodel, @Nonnull BBModelParts.OutlinerNode node, BBModelParts.OutlinerGroup parent) {
        if (node instanceof BBModelParts.OutlinerGroup) {
            this.parseOutlinerGroup(bbmodel, (BBModelParts.OutlinerGroup)node, parent);
        } else {
            this.parseOutlinerCube(bbmodel, (BBModelParts.OutlinerCube)node, parent);
        }
    }

    private void parse(@Nonnull BBModel bbmodel) {
        bbmodel.textureImages = new ArrayList<BufferedImage>(bbmodel.textures.size());
        bbmodel.uuidMap = new HashMap<String, BBModelParts.ElementBase>(bbmodel.elements.size());
        for (BBModelParts.Element element : bbmodel.elements) {
            bbmodel.uuidMap.put(element.uuid, element);
        }
        bbmodel.outlinerFlatList = new ArrayList<BBModelParts.ElementBase>(bbmodel.elements.size());
        for (BBModelParts.OutlinerNode outlinerNode : bbmodel.outliner) {
            this.parseOutliner(bbmodel, outlinerNode, null);
        }
        if (bbmodel.animations != null) {
            bbmodel.animationPerName = new HashMap<String, BBModelParts.Animation>(bbmodel.animations.size());
            for (BBModelParts.Animation animation : bbmodel.animations) {
                bbmodel.animationPerName.put(animation.name, animation);
            }
        }
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(Direction.class, (Object)new DirectionAdapter());
        gsonBuilder.registerTypeAdapter(Vector3.class, (Object)new Vector3Adapter());
        gson = gsonBuilder.create();
    }

    public static class DirectionAdapter
    extends TypeAdapter<Direction> {
        public void write(JsonWriter out, Direction value) throws IOException {
            out.value(value.name().toLowerCase());
        }

        public Direction read(JsonReader in) throws IOException {
            return Direction.valueOf((String)in.nextString().toUpperCase());
        }
    }

    public static class Vector3Adapter
    extends TypeAdapter<Vector3> {
        public void write(JsonWriter out, Vector3 value) throws IOException {
            out.beginArray();
            out.value(value.x);
            out.value(value.y);
            out.value(value.z);
            out.endArray();
        }

        public Vector3 read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            float x = (float)in.nextDouble();
            float y = (float)in.nextDouble();
            float z = (float)in.nextDouble();
            in.endArray();
            return new Vector3(x, y, z);
        }
    }

    public static class DataPointAdapter
    extends TypeAdapter<BBModelParts.DataPoint> {
        public void write(JsonWriter out, BBModelParts.DataPoint value) throws IOException {
            out.beginObject();
            out.name("x");
            out.value(value.x);
            out.name("y");
            out.value(value.y);
            out.name("z");
            out.value(value.z);
            if (value.effect != null) {
                out.name("effect");
                out.value(value.effect);
            }
            if (value.file != null) {
                out.name("file");
                out.value(value.file);
            }
            out.endObject();
        }

        public BBModelParts.DataPoint read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            BBModelParts.DataPoint dataPoint = new BBModelParts.DataPoint();
            in.beginObject();
            String fieldname = null;
            while (in.hasNext()) {
                if (in.peek().equals((Object)JsonToken.NAME)) {
                    fieldname = in.nextName();
                }
                if ("x".equals(fieldname)) {
                    dataPoint.x = (float)new ExpressionBuilder(in.nextString()).build().evaluate();
                }
                if ("y".equals(fieldname)) {
                    dataPoint.y = (float)new ExpressionBuilder(in.nextString()).build().evaluate();
                }
                if ("z".equals(fieldname)) {
                    dataPoint.z = (float)new ExpressionBuilder(in.nextString()).build().evaluate();
                }
                if ("effect".equals(fieldname)) {
                    dataPoint.effect = in.nextString();
                }
                if (!"file".equals(fieldname)) continue;
                dataPoint.file = in.nextString();
            }
            in.endObject();
            return dataPoint;
        }
    }

    public static class EnumInterpolationAdapter
    extends TypeAdapter<BBModelParts.Interpolation> {
        public void write(JsonWriter out, BBModelParts.Interpolation value) throws IOException {
            out.value(value.name().toLowerCase());
        }

        public BBModelParts.Interpolation read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return BBModelParts.Interpolation.valueOf(in.nextString().toUpperCase(Locale.ROOT));
        }
    }

    public static class EnumChannelAdapter
    extends TypeAdapter<BBModelParts.Channel> {
        public void write(JsonWriter out, BBModelParts.Channel value) throws IOException {
            out.value(value.name().toLowerCase());
        }

        public BBModelParts.Channel read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return BBModelParts.Channel.valueOf(in.nextString().toUpperCase(Locale.ROOT));
        }
    }

    public static class VisibleBoundsAdapter
    extends TypeAdapter<BBModelParts.VisibleBounds> {
        public void write(JsonWriter out, BBModelParts.VisibleBounds value) throws IOException {
            out.beginArray();
            out.value(value.x);
            out.value(value.y);
            out.value(value.z);
            out.endArray();
        }

        public BBModelParts.VisibleBounds read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            BBModelParts.VisibleBounds readVisibleBounds = new BBModelParts.VisibleBounds();
            readVisibleBounds.x = (float)in.nextDouble();
            readVisibleBounds.y = (float)in.nextDouble();
            readVisibleBounds.z = (float)in.nextDouble();
            in.endArray();
            return readVisibleBounds;
        }
    }

    public static class UVOffsetAdapter
    extends TypeAdapter<BBModelParts.UVOffset> {
        public void write(JsonWriter out, BBModelParts.UVOffset value) throws IOException {
            out.beginArray();
            out.value(value.u_offset);
            out.value(value.v_offset);
            out.endArray();
        }

        public BBModelParts.UVOffset read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            BBModelParts.UVOffset readUVOffset = new BBModelParts.UVOffset();
            readUVOffset.u_offset = (float)in.nextDouble();
            readUVOffset.v_offset = (float)in.nextDouble();
            in.endArray();
            return readUVOffset;
        }
    }

    public static class OutlinerNodeAdapter
    extends TypeAdapter<BBModelParts.OutlinerNode> {
        public void write(JsonWriter out, BBModelParts.OutlinerNode value) throws IOException {
        }

        public BBModelParts.OutlinerNode read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (in.peek() == JsonToken.BEGIN_OBJECT) {
                return (BBModelParts.OutlinerNode)gson.fromJson(in, BBModelParts.OutlinerGroup.class);
            }
            BBModelParts.OutlinerCube cube = new BBModelParts.OutlinerCube();
            cube.uuid = in.nextString();
            return cube;
        }
    }

    public static class MarkerColorAdapter
    extends TypeAdapter<BBModelParts.MarkerColor> {
        public void write(JsonWriter out, BBModelParts.MarkerColor value) throws IOException {
            out.value((long)value.ordinal());
        }

        public BBModelParts.MarkerColor read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return BBModelParts.MarkerColor.LightBlue;
            }
            return BBModelParts.MarkerColor.values()[in.nextInt()];
        }
    }

    public static class UVCoordinateAdapter
    extends TypeAdapter<BBModelParts.UVCoordinate> {
        public void write(JsonWriter out, BBModelParts.UVCoordinate value) throws IOException {
            out.beginArray();
            out.value(value.u0);
            out.value(value.v0);
            out.value(value.u1);
            out.value(value.v1);
            out.endArray();
        }

        public BBModelParts.UVCoordinate read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            BBModelParts.UVCoordinate readUVCoord = new BBModelParts.UVCoordinate();
            readUVCoord.u0 = (float)in.nextDouble();
            readUVCoord.v0 = (float)in.nextDouble();
            readUVCoord.u1 = (float)in.nextDouble();
            readUVCoord.v1 = (float)in.nextDouble();
            in.endArray();
            return readUVCoord;
        }
    }
}

