/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.common.blocks;

import com.razz.decocraft_nature.common.JsonContainer;
import com.razz.decocraft_nature.common.ModuleBlocks;
import com.razz.decocraft_nature.common.ModuleSounds;
import com.razz.decocraft_nature.common.ModuleTileEntities;
import com.razz.decocraft_nature.common.tileentities.DecocraftTileEntity;
import com.razz.decocraft_nature.models.bbmodel.BBHitBox;
import com.razz.decocraft_nature.models.bbmodel.BBModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class DecocraftBlock
extends class_2248
implements class_2343 {
    private static final Map<String, class_265[]> CACHE_HIT_BOXES = Collections.synchronizedMap(new HashMap());
    public final JsonContainer.Entry meta;
    public final BBModel model;
    private class_265[] shape;

    public DecocraftBlock(JsonContainer.Entry meta, BBModel model) {
        super(DecocraftBlock.getProperties(meta));
        this.meta = meta;
        this.model = model;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
    }

    private static class_4970.class_2251 getProperties(JsonContainer.Entry meta) {
        class_4970.class_2251 settings = meta.passable ? class_4970.class_2251.method_9637().method_31710(class_3620.field_16023).method_9634() : class_4970.class_2251.method_9637().method_31710(class_3620.field_16023).method_22488();
        if (meta.lighting > 0) {
            settings = settings.method_9631(state -> meta.lighting);
        }
        return settings;
    }

    public static void script(class_1937 world, class_2338 blockPos, class_2680 blockState, JsonContainer.Action action) {
        if (action != null) {
            if (action.link != null) {
                DecocraftBlock.scriptLink(world, blockPos, blockState, action.link);
            }
            if (action.sound != null) {
                DecocraftBlock.scriptSound(world, blockPos, blockState, action.sound);
            }
            if (action.animations != null) {
                DecocraftBlock.scriptAnimations(world, blockPos, blockState, action.animations);
            }
        }
    }

    public static void scriptLink(class_1937 world, class_2338 blockPos, class_2680 blockState, String link) {
        if (link == null || link.isEmpty()) {
            return;
        }
        class_2248 targetBlock = ModuleBlocks.DECOBLOCKS.get(link);
        if (targetBlock != null) {
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
            class_2680 state = (class_2680)targetBlock.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
            world.method_8652(blockPos, state, 10);
        } else {
            System.err.println("Block not found for link: " + link);
            System.err.println("Available blocks: " + String.valueOf(ModuleBlocks.DECOBLOCKS.keySet().stream().filter(k -> k.contains("ceiling_fan")).toArray()));
        }
    }

    public static void scriptSound(class_1937 world, class_2338 blockPos, class_2680 blockState, String sound) {
        if (sound != null && !sound.isEmpty()) {
            class_3414 soundEvent = ModuleSounds.SOUNDS.get(sound);
            if (soundEvent != null) {
                world.method_8396(null, blockPos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            } else {
                System.err.println("Sound not found: " + sound + ". Available sounds: " + String.valueOf(ModuleSounds.SOUNDS.keySet()));
            }
        }
    }

    public static void scriptAnimations(class_1937 world, class_2338 blockPos, class_2680 blockState, List<JsonContainer.Animation> animations) {
        if (!world.field_9236) {
            // empty if block
        }
    }

    @Environment(value=EnvType.CLIENT)
    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    private class_265[] parseHitBox(JsonContainer.Entry meta, BBModel model) {
        if (meta == null || meta.model == null) {
            return new class_265[]{class_259.method_1077()};
        }
        String cacheKey = meta.model + "_" + (meta.scale != 0.0f ? meta.scale : 1.0f) + "_" + (meta.shape != null ? meta.shape : "default");
        if (!CACHE_HIT_BOXES.containsKey(cacheKey)) {
            BBModel hitboxModel = null;
            if (meta.shape != null) {
                hitboxModel = ModuleBlocks.MAT_TO_BB_MODEL.get(meta.shape);
            }
            if (hitboxModel == null) {
                class_265[] defaultShape = new class_265[]{class_259.method_1077()};
                CACHE_HIT_BOXES.put(cacheKey, defaultShape);
                return defaultShape;
            }
            CACHE_HIT_BOXES.put(cacheKey, BBHitBox.parse(meta.scale, hitboxModel));
        }
        return CACHE_HIT_BOXES.get(cacheKey);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)context.method_8042().method_10153());
    }

    public long getSeed(class_2680 blockState, class_2338 blockPos) {
        return class_2338.method_10064((int)blockPos.method_10263(), (int)blockPos.method_10264(), (int)blockPos.method_10260());
    }

    public class_265 method_9530(class_2680 blockState, class_1922 world, class_2338 blockPos, class_3726 context) {
        if (this.shape == null) {
            this.shape = this.parseHitBox(this.meta, this.model);
            if (this.shape == null) {
                return class_259.method_1077();
            }
        }
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
        switch (direction) {
            case field_11043: {
                return this.shape.length > 0 ? this.shape[0] : class_259.method_1077();
            }
            case field_11035: {
                return this.shape.length > 1 ? this.shape[1] : class_259.method_1077();
            }
            case field_11034: {
                return this.shape.length > 2 ? this.shape[2] : class_259.method_1077();
            }
            case field_11039: {
                return this.shape.length > 3 ? this.shape[3] : class_259.method_1077();
            }
        }
        return this.shape.length > 0 ? this.shape[0] : class_259.method_1077();
    }

    public class_1269 method_9534(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 playerEntity, class_1268 hand, class_3965 blockHitResult) {
        if (playerEntity.method_5715() && this.meta.script != null && this.meta.script.shift_on_use != null) {
            DecocraftBlock.script(world, blockPos, blockState, this.meta.script.shift_on_use);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (!playerEntity.method_5715() && this.meta.script != null && this.meta.script.on_use != null) {
            DecocraftBlock.script(world, blockPos, blockState, this.meta.script.on_use);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        DecocraftBlock.script(world, pos, state, this.meta.script.added);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        DecocraftBlock.script(world, pos, state, this.meta.script.removed);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (this.meta.script != null && (this.meta.script.trigger != null || this.meta.script.on_use != null)) {
            return new DecocraftTileEntity(ModuleTileEntities.DECOCRAFT, pos, state);
        }
        return null;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (this.meta.script != null && (this.meta.script.trigger != null || this.meta.script.on_use != null)) {
            return DecocraftBlock.checkType(type, ModuleTileEntities.DECOCRAFT, DecocraftTileEntity::tick);
        }
        return null;
    }

    private static <E extends class_2586, A extends class_2586> class_5558<A> checkType(class_2591<A> givenType, class_2591<E> expectedType, class_5558<E> ticker) {
        return expectedType == givenType ? ticker : null;
    }

    public boolean hasTileEntity(class_2680 state) {
        return this.meta != null && this.meta.script != null && this.meta.script.trigger != null;
    }

    public class_265[] getShape() {
        if (this.shape == null) {
            this.shape = this.parseHitBox(this.meta, this.model);
        }
        return this.shape;
    }

    public void onToolModelSwitch(class_2680 state, class_1937 world, class_2338 pos) {
        if (this.meta != null && this.meta.script != null && this.meta.script.tool_modelswitch != null) {
            DecocraftBlock.script(world, pos, state, this.meta.script.tool_modelswitch);
        }
    }
}

