/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.models.bbmodel;

import com.google.gson.annotations.JsonAdapter;
import com.razz.decocraft_nature.models.bbmodel.BBModelLoader;
import com.razz.decocraft_nature.models.libgdx.Vector3;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2350;

public class BBModelParts {

    @JsonAdapter(value=BBModelLoader.DataPointAdapter.class)
    public static class DataPoint {
        public float x;
        public float y;
        public float z;
    }

    public static class Keyframe {
        public Channel channel;
        public String uuid;
        public float time = -1.0f;
        public int color;
        public Interpolation interpolation;
        public boolean bezier_linked;
        public List<Float> bezier_left_time;
        public List<Float> bezier_left_value;
        public List<Float> bezier_right_time;
        public List<Float> bezier_right_value;
        public List<DataPoint> data_points;
    }

    public static class Animator {
        public String name;
        public String type;
        public List<Keyframe> keyframes;
    }

    public static class Animation {
        public String uuid;
        public String name;
        public String loop;
        public boolean override;
        public float length;
        public int snapping;
        public boolean selected;
        public boolean saved;
        public String path;
        public String anim_time_update;
        public String blend_weight;
        public String start_delay;
        public String loop_delay;
        public Map<UUID, Animator> animators = new HashMap<UUID, Animator>();
    }

    public static class Texture {
        public String path;
        public String name;
        public String folder;
        public String namespace;
        public String id;
        public boolean particle;
        public String render_mode;
        public boolean visible;
        public String mode;
        public boolean saved;
        public UUID uuid;
        public String relative_path;
        public String source;
    }

    public static class OutlinerCube
    implements OutlinerNode {
        public UUID uuid;

        public String toString() {
            return "<OutlinerCube - " + String.valueOf(this.uuid) + ">";
        }
    }

    public static class OutlinerGroup
    extends ElementBase
    implements OutlinerNode {
        public String bedrock_binding;
        public boolean isOpen = true;
        public List<OutlinerNode> children;

        @Override
        public String toString() {
            return "<OutlinerGroup - " + this.name + ">";
        }
    }

    public static class Element
    extends ElementBase {
        public boolean rescale;
        public Vector3 from;
        public Vector3 to;
        public Vector3 position;
        public UVOffset uv_offset;
        public Map<class_2350, Face> faces;
        public float inflate;
    }

    public static class ElementBase {
        public UUID uuid;
        public String name;
        public String type = "";
        public Vector3 origin = new Vector3(0.0f, 0.0f, 0.0f);
        public Vector3 rotation = new Vector3(0.0f, 0.0f, 0.0f);
        public MarkerColor color;
        public int autouv;
        public boolean shade = true;
        public boolean export;
        public boolean locked;
        public boolean visibility;
        public transient OutlinerGroup parent;

        public String toString() {
            return "<BBModel - " + (this.type.isEmpty() ? "outliner" : this.type) + ": " + this.name + ">";
        }
    }

    @JsonAdapter(value=BBModelLoader.VisibleBoundsAdapter.class)
    public static class VisibleBounds {
        public float x;
        public float y;
        public float z;
    }

    @JsonAdapter(value=BBModelLoader.UVOffsetAdapter.class)
    public static class UVOffset {
        public int u_offset;
        public int v_offset;
    }

    @JsonAdapter(value=BBModelLoader.UVCoordinateAdapter.class)
    public static class UVCoordinate {
        public float u0;
        public float v0;
        public float u1;
        public float v1;
    }

    public static class Resolution {
        public int width;
        public int height;
    }

    public static class Meta {
        public String format_version;
        public int creation_time;
        public String model_format;
        public boolean box_uv;
    }

    public static class Face {
        public UVCoordinate uv;
        public int texture;
        public float rotation = 0.0f;
    }

    @JsonAdapter(value=BBModelLoader.OutlinerNodeAdapter.class)
    public static interface OutlinerNode {
    }

    @JsonAdapter(value=BBModelLoader.EnumInterpolationAdapter.class)
    public static enum Interpolation {
        LINEAR,
        CATMULLROM;

    }

    @JsonAdapter(value=BBModelLoader.EnumChannelAdapter.class)
    public static enum Channel {
        ROTATION,
        POSITION,
        SCALE;

    }

    @JsonAdapter(value=BBModelLoader.MarkerColorAdapter.class)
    public static enum MarkerColor {
        LightBlue,
        Yellow,
        Orange,
        Red,
        Purple,
        Blue,
        Green,
        Lime,
        Pink,
        Silver;

    }
}

