/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.common.containers;

import com.razz.decocraft_nature.common.ModuleContainers;
import com.razz.decocraft_nature.common.items.DecoBlockItem;
import com.razz.decocraft_nature.common.tileentities.DecomposerTileEntity;
import com.razz.mods_nature.Mods;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class DecomposerContainer
extends AbstractContainerMenu {
    private static final int SPACING = 18;
    private static final int INVENTORY_X = -26;
    private static final int INVENTORY_Y = 117;
    public final NonNullList<ItemStack> items = NonNullList.m_122779_();
    public final ContainerLevelAccess access;
    public int[] crafting = new int[2];
    public int[] fuel = new int[1];
    private DecomposerTileEntity decomposerTE;
    private Level world;

    public DecomposerContainer(int containerId, Inventory inventory) {
        this(containerId, inventory, ContainerLevelAccess.f_39287_);
    }

    public DecomposerContainer(int containerId, Inventory inventory, ContainerLevelAccess access) {
        super(ModuleContainers.DECOMPOSER, containerId);
        this.access = access;
        this.access.m_39292_((world, pos) -> {
            this.decomposerTE = (DecomposerTileEntity)world.m_7702_(pos);
            this.world = world;
        });
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, -26 + i * 18, 117));
        }
        this.m_38897_(new Slot((Container)(this.decomposerTE == null ? new SimpleContainer(1) : this.decomposerTE.getInput()), 0, 28, 38){

            public boolean m_5857_(ItemStack stack) {
                if (stack == ItemStack.f_41583_) {
                    return false;
                }
                boolean found = stack.m_41720_() instanceof DecoBlockItem;
                if (!found) {
                    for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                        if (!stack.m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getKey()))) && !stack.m_204117_(new TagKey(ForgeRegistries.Keys.ITEMS, new ResourceLocation(entry.getKey())))) continue;
                        found = true;
                        break;
                    }
                }
                return found;
            }
        });
        this.m_38897_(new Slot((Container)(this.decomposerTE == null ? new SimpleContainer(1) : this.decomposerTE.getResult()), 0, 63, 38){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38897_(new Slot((Container)(this.decomposerTE == null ? new SimpleContainer(1) : this.decomposerTE.getFuel()), 0, 10, 84){

            public boolean m_5857_(ItemStack stack) {
                if ("minecraft:bone_meal".equals("")) {
                    return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
                }
                return stack.m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:bone_meal")));
            }
        });
        this.m_38895_(DataSlot.m_39406_((int[])this.crafting, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.crafting, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.fuel, (int)0));
        this.getTEData();
    }

    private void getTEData() {
        if (this.world != null && !this.world.m_5776_()) {
            this.crafting[0] = this.decomposerTE.getCraft();
            this.crafting[1] = this.decomposerTE.getCraftingTimer();
            this.fuel[0] = this.decomposerTE.getCurrentFuel();
        }
    }

    public boolean m_6875_(Player player) {
        return (Boolean)this.access.m_39299_((world, pos) -> player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public void m_38946_() {
        this.getTEData();
        super.m_38946_();
    }

    public ItemStack m_7648_(Player player, int i) {
        return null;
    }

    public void m_150399_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        ClickType type = pClickType == ClickType.QUICK_MOVE ? ClickType.PICKUP : pClickType;
        this.m_150430_(pSlotId, pButton, type, pPlayer);
    }

    public void craft(int craft) {
        this.decomposerTE.setCraft(craft);
    }
}

