/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.common;

import com.razz.decocraft_nature.common.JsonContainer;
import com.razz.decocraft_nature.common.ModuleItems;
import com.razz.decocraft_nature.common.blocks.DecoAnimatedBlock;
import com.razz.decocraft_nature.common.blocks.DecoBedBlock;
import com.razz.decocraft_nature.common.blocks.DecoFakeBlock;
import com.razz.decocraft_nature.common.blocks.DecoSeatBlock;
import com.razz.decocraft_nature.common.blocks.DecobenchBlock;
import com.razz.decocraft_nature.common.blocks.DecocraftBlock;
import com.razz.decocraft_nature.common.blocks.DecomposerBlock;
import com.razz.decocraft_nature.common.groups.GroupSelector;
import com.razz.decocraft_nature.common.items.DecoBlockItem;
import com.razz.decocraft_nature.models.bbmodel.BBModel;
import com.razz.decocraft_nature.utils.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModuleBlocks {
    public static final DeferredRegister<Block> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"decocraft_nature");
    public static Map<String, RegistryObject<Block>> DECOBLOCKS = new HashMap<String, RegistryObject<Block>>();
    public static Block[] SCRIPT_FLIPBOOK_TE_NEEDED;
    public static Block[] ANIMATED_TE_NEEDED;
    public static Block[] DECOBENCH_TE_NEEDED;
    public static Block[] DECOMPOSER_TE_NEEDED;
    public static Map<String, BBModel> MAT_TO_BB_MODEL;
    public static RegistryObject<Block> DECOFAKE;

    private static void collectModels(List<JsonContainer.Entry> models, List<JsonContainer.Entry> boundingBoxes) {
        String[] paths;
        for (String path : paths = JsonParser.parseFiles("assets/decocraft_nature/decocraft.json")) {
            JsonContainer entries = JsonParser.parseDecocraft("assets/decocraft_nature/" + path);
            models.addAll(Arrays.stream(entries.models).collect(Collectors.toList()));
            boundingBoxes.addAll(Arrays.stream(entries.bounding_boxes).collect(Collectors.toList()));
        }
    }

    private static void registerFlipbooks(List<JsonContainer.Entry> models) {
        ArrayList<JsonContainer.Entry> toAdd = new ArrayList<JsonContainer.Entry>();
        ArrayList<JsonContainer.Entry> toRemove = new ArrayList<JsonContainer.Entry>();
        for (JsonContainer.Entry meta : models) {
            if (meta.flipbook == null || meta.flipbook.images < 2) continue;
            for (int i = 0; i < meta.flipbook.images; ++i) {
                JsonContainer.Entry entry = new JsonContainer.Entry(meta);
                entry.decoref = String.format("%s.%02d", meta.decoref != null ? meta.decoref : meta.material, i);
                entry.material = String.format("%s.%02d", meta.material, i);
                if (i != 0) {
                    entry.hidden = true;
                }
                toAdd.add(entry);
            }
            toRemove.add(meta);
        }
        models.removeAll(toRemove);
        models.addAll(toAdd);
    }

    private static void readModels(List<JsonContainer.Entry> models, Map<String, BBModel> matToModel) {
        ZipFile zipfile = JsonParser.openZip();
        for (JsonContainer.Entry meta : models) {
            BBModel model = JsonParser.parseModel("assets/decocraft_nature/models/bbmodel/" + meta.model + ".bbmodel", zipfile);
            if (meta.decoref == null) {
                meta.decoref = meta.material;
            }
            if (meta.shape == null) {
                meta.shape = meta.decoref;
            }
            matToModel.put(meta.decoref, model);
            MAT_TO_BB_MODEL.put(meta.decoref, model);
        }
        JsonParser.closeZip(zipfile);
    }

    private static void readBoundingBoxes(List<JsonContainer.Entry> boundingBoxes) {
        ZipFile zipfile = JsonParser.openZip();
        for (JsonContainer.Entry meta : boundingBoxes) {
            BBModel model = JsonParser.parseModel("assets/decocraft_nature/bounding_boxes/bbmodel/" + meta.model + ".bbmodel", zipfile);
            MAT_TO_BB_MODEL.put(meta.decoref != null ? meta.decoref : meta.model, model);
        }
        JsonParser.closeZip(zipfile);
    }

    private static void registerModels(List<JsonContainer.Entry> models, Map<String, BBModel> matToModel) {
        ArrayList<DecocraftBlock> scriptTeNeeded = new ArrayList<DecocraftBlock>();
        ArrayList<DecocraftBlock> animatedTeNeeded = new ArrayList<DecocraftBlock>();
        ArrayList<DecocraftBlock> decobenchTeNeeded = new ArrayList<DecocraftBlock>();
        ArrayList<DecocraftBlock> decomposerTeNeeded = new ArrayList<DecocraftBlock>();
        for (JsonContainer.Entry meta : models) {
            DecocraftBlock block;
            CreativeModeTab group = GroupSelector.SELECT.get(meta.tabs);
            BBModel model = matToModel.get(meta.decoref);
            if (meta.type != null) {
                switch (meta.type) {
                    case "bed": {
                        block = new DecoBedBlock(meta, model);
                        break;
                    }
                    case "seat": {
                        block = new DecoSeatBlock(meta, model);
                        break;
                    }
                    case "animated": {
                        block = new DecoAnimatedBlock(meta, model);
                        break;
                    }
                    case "fake_block": {
                        block = new DecoFakeBlock(meta, model);
                        break;
                    }
                    case "decobench": {
                        block = new DecobenchBlock(meta, model);
                        break;
                    }
                    case "decomposer": {
                        block = new DecomposerBlock(meta, model);
                        break;
                    }
                    default: {
                        block = new DecocraftBlock(meta, model);
                        break;
                    }
                }
            } else {
                block = new DecocraftBlock(meta, model);
            }
            RegistryObject<Block> register = meta.hidden ? ModuleBlocks.register(meta.decoref, block) : ModuleBlocks.register(meta.decoref, (Block)block, group);
            DECOBLOCKS.put(meta.decoref, register);
            if (Objects.equals(meta.type, "fake_block")) {
                DECOFAKE = register;
            }
            if (meta.script != null && meta.script.trigger != null || meta.flipbook.images > 1) {
                scriptTeNeeded.add(block);
                continue;
            }
            if (Objects.equals(meta.type, "animated")) {
                animatedTeNeeded.add(block);
                continue;
            }
            if (Objects.equals(meta.type, "decobench")) {
                decobenchTeNeeded.add(block);
                continue;
            }
            if (!Objects.equals(meta.type, "decomposer")) continue;
            decomposerTeNeeded.add(block);
        }
        SCRIPT_FLIPBOOK_TE_NEEDED = scriptTeNeeded.toArray(new Block[0]);
        ANIMATED_TE_NEEDED = animatedTeNeeded.toArray(new Block[0]);
        DECOBENCH_TE_NEEDED = decobenchTeNeeded.toArray(new Block[0]);
        DECOMPOSER_TE_NEEDED = decomposerTeNeeded.toArray(new Block[0]);
    }

    private static RegistryObject<Block> register(String name, Block block) {
        return ModuleBlocks.register(name, block, (Supplier<BlockItem>)null);
    }

    private static RegistryObject<Block> register(String name, Block block, CreativeModeTab group) {
        return ModuleBlocks.register(name, block, new Item.Properties().m_41491_(group));
    }

    private static RegistryObject<Block> register(String name, Block block, Item.Properties properties) {
        return ModuleBlocks.register(name, block, () -> new DecoBlockItem(block, properties));
    }

    private static RegistryObject<Block> register(String name, Block block, @Nullable Supplier<BlockItem> supplier) {
        if (supplier != null) {
            ModuleItems.REGISTER.register(name, supplier);
        }
        return REGISTER.register(name, () -> block);
    }

    private static RegistryObject<Block> register(String name, Block block, @Nullable Function<Block, BlockItem> function) {
        if (function != null) {
            ModuleItems.REGISTER.register(name, () -> (BlockItem)function.apply(block));
        }
        return REGISTER.register(name, () -> block);
    }

    static {
        MAT_TO_BB_MODEL = new HashMap<String, BBModel>();
        ArrayList<JsonContainer.Entry> models = new ArrayList<JsonContainer.Entry>();
        ArrayList<JsonContainer.Entry> boundingBoxes = new ArrayList<JsonContainer.Entry>();
        HashMap<String, BBModel> matToModel = new HashMap<String, BBModel>();
        ModuleBlocks.collectModels(models, boundingBoxes);
        ModuleBlocks.registerFlipbooks(models);
        ModuleBlocks.readModels(models, matToModel);
        ModuleBlocks.readBoundingBoxes(boundingBoxes);
        ModuleBlocks.registerModels(models, matToModel);
    }
}

