/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.network.client;

import com.razz.decocraft_nature.common.containers.DecomposerContainer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class CDecomposerCraft {
    public final int craft;

    public CDecomposerCraft(int craft) {
        this.craft = craft;
    }

    public static CDecomposerCraft decoder(FriendlyByteBuf buffer) {
        int craft = buffer.readInt();
        return new CDecomposerCraft(craft);
    }

    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeInt(this.craft);
    }

    public static class Handler {
        public static void handle(CDecomposerCraft message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Handler.handlePacket(message, ctx));
        }

        private static void handlePacket(CDecomposerCraft message, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                ctx.get().setPacketHandled(true);
                return;
            }
            AbstractContainerMenu container = player.f_36096_;
            if (!(container instanceof DecomposerContainer)) {
                ctx.get().setPacketHandled(true);
                return;
            }
            DecomposerContainer decomposer = (DecomposerContainer)container;
            decomposer.craft(message.craft);
            ctx.get().setPacketHandled(true);
        }
    }
}

