/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.init;

import com.jahirtrap.critterarmory.init.ModMaterials;
import com.jahirtrap.critterarmory.item.BaseAnimalArmorItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModContent {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"critterarmory");
    public static final List<RegistryObject<Item>> COPPER_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.MobArmor.COPPER, new Item.Properties());
    public static final List<RegistryObject<Item>> IRON_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.MobArmor.IRON, new Item.Properties());
    public static final List<RegistryObject<Item>> GOLD_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.MobArmor.GOLD, new Item.Properties());
    public static final List<RegistryObject<Item>> DIAMOND_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.MobArmor.DIAMOND, new Item.Properties());
    public static final List<RegistryObject<Item>> NETHERITE_MOB_ARMORS = ModContent.registerMobArmors(ModMaterials.MobArmor.NETHERITE, new Item.Properties().fireResistant());
    public static final RegistryObject<Item> BALANCED_FEED = ModContent.registerItem("balanced_feed", Item::new, new Item.Properties());
    public static final RegistryObject<Item> VITALITY_FEED = ModContent.registerItem("vitality_feed", Item::new, new Item.Properties());

    private static RegistryObject<Item> registerItem(String name, Function<Item.Properties, Item> function, Item.Properties itemProp) {
        return ITEMS.register(name, () -> (Item)function.apply(itemProp.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"critterarmory", (String)name)))));
    }

    private static List<RegistryObject<Item>> registerMobArmors(Map.Entry<ArmorMaterial, String> entry, Item.Properties itemProp) {
        ArrayList<RegistryObject<Item>> items = new ArrayList<RegistryObject<Item>>();
        if (entry.getKey() != ModMaterials.MobArmor.COPPER.getKey() && entry.getKey() != ModMaterials.MobArmor.IRON.getKey() && entry.getKey() != ModMaterials.MobArmor.GOLD.getKey() && entry.getKey() != ModMaterials.MobArmor.DIAMOND.getKey()) {
            items.add(ModContent.registerItem(entry.getValue() + "_horse_armor", p -> new Item(p.horseArmor((ArmorMaterial)entry.getKey())), itemProp));
        }
        items.add(ModContent.registerItem(entry.getValue() + "_wolf_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.CANINE, (Item.Properties)p), itemProp));
        items.add(ModContent.registerItem(entry.getValue() + "_cat_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.CAT, (Item.Properties)p), itemProp));
        items.add(ModContent.registerItem(entry.getValue() + "_chicken_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.CHICKEN, (Item.Properties)p), itemProp));
        items.add(ModContent.registerItem(entry.getValue() + "_cow_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.COW, (Item.Properties)p), itemProp));
        items.add(ModContent.registerItem(entry.getValue() + "_pig_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.PIG, (Item.Properties)p), itemProp));
        items.add(ModContent.registerItem(entry.getValue() + "_sheep_armor", p -> new BaseAnimalArmorItem((ArmorMaterial)entry.getKey(), BaseAnimalArmorItem.BodyType.SHEEP, (Item.Properties)p), itemProp));
        return items;
    }

    public static void init(BusGroup bus) {
        ITEMS.register(bus);
    }
}

