/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.init.mixin;

import com.jahirtrap.critterarmory.util.CommonUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Animal.class})
public abstract class AnimalMixin {
    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Animal entity = (Animal)this;
        ItemStack stack = player.getItemInHand(hand);
        if (CommonUtils.canFeed((LivingEntity)entity) && this.tamable(player) && CommonUtils.feedEntity(player, hand, entity)) {
            cir.setReturnValue((Object)InteractionResult.SUCCESS_SERVER);
        }
        if (CommonUtils.canWearArmor((LivingEntity)entity) && entity.isEquippableInSlot(stack, EquipmentSlot.BODY) && !entity.isWearingBodyArmor() && !entity.isBaby()) {
            entity.setBodyArmorItem(stack.copyWithCount(1));
            stack.consume(1, (LivingEntity)player);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Unique
    private boolean tamable(Player player) {
        TamableAnimal tamable;
        Animal animal = (Animal)this;
        return !(animal instanceof TamableAnimal) || (tamable = (TamableAnimal)animal).isTame() && tamable.isOwnedBy((LivingEntity)player);
    }
}

