/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.init.mixin;

import com.jahirtrap.critterarmory.layer.ChickenArmorLayer;
import com.jahirtrap.critterarmory.util.RenderStates;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.renderer.entity.ChickenRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ChickenRenderState;
import net.minecraft.world.entity.animal.Chicken;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChickenRenderer.class})
public abstract class ChickenRendererMixin {
    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V"}, at={@At(value="TAIL")})
    private void init(EntityRendererProvider.Context context, CallbackInfo ci) {
        ChickenRenderer renderer = (ChickenRenderer)this;
        renderer.addLayer((RenderLayer)new ChickenArmorLayer((RenderLayerParent<ChickenRenderState, ChickenModel>)renderer, context.getModelSet()));
    }

    @Inject(method={"createRenderState*"}, at={@At(value="RETURN")}, cancellable=true)
    private void createRenderState(CallbackInfoReturnable<ChickenRenderState> cir) {
        cir.setReturnValue((Object)new RenderStates.Chicken());
    }

    @Inject(method={"extractRenderState*"}, at={@At(value="HEAD")})
    private void extractRenderState(Chicken entity, ChickenRenderState renderState, float f, CallbackInfo ci) {
        if (renderState instanceof RenderStates.Chicken) {
            RenderStates.Chicken armorRenderState = (RenderStates.Chicken)renderState;
            armorRenderState.bodyArmorItem = entity.getBodyArmorItem();
        }
    }
}

