/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragncrops.event;

import com.dragn0007.dragncrops.blocks.COBlocks;
import com.dragn0007.dragncrops.blocks.custom.AppleBlock;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvent {
    @SubscribeEvent
    public static void onBlockUse(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos = event.getPos());
        Property<Integer> property = ForgeEvent.getCropProperty(state, "age");
        if (property != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int maxAge = ForgeEvent.getMaxAge(state.m_60734_());
            InteractionHand hand = event.getHand();
            Player player = event.getEntity();
            ItemStack itemStack = player.m_21120_(hand);
            if (itemStack.m_41619_() && (Integer)state.m_61143_(property) == maxAge) {
                level.m_46597_(pos, (BlockState)state.m_61124_(property, (Comparable)Integer.valueOf(0)));
                state.m_60734_();
                Block.m_49869_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null).forEach(stack -> serverLevel.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack)));
            }
        }
    }

    private static Property<Integer> getCropProperty(BlockState state, String propertyName) {
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            for (Property prop : state.m_61147_()) {
                if (!(prop instanceof IntegerProperty) || !prop.m_61708_().equals(propertyName)) continue;
                return prop;
            }
        }
        return null;
    }

    private static int getMaxAge(Block block) {
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_7419_();
        }
        return 7;
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockState blockState;
        Direction playerFacing;
        BlockPos blockPos;
        Level level = event.getLevel();
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        if (itemStack.m_150930_(Items.f_42406_) && level.m_46859_(blockPos = event.getPos().m_121945_(Objects.requireNonNull(event.getFace())))) {
            if (!level.f_46443_) {
                playerFacing = player.m_6350_();
                blockState = (BlockState)((Block)COBlocks.BREAD.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)playerFacing.m_122424_());
                level.m_7731_(blockPos, blockState, 3);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
        if (itemStack.m_150930_(Items.f_42405_) && level.m_46859_(blockPos = event.getPos().m_121945_(Objects.requireNonNull(event.getFace())))) {
            if (!level.f_46443_) {
                playerFacing = player.m_6350_();
                blockState = (BlockState)((Block)COBlocks.WHEAT_GRAIN.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)playerFacing.m_122424_());
                level.m_7731_(blockPos, blockState, 3);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
        if (itemStack.m_150930_(Items.f_42410_)) {
            blockPos = event.getPos().m_121945_(Objects.requireNonNull(event.getFace()));
            if (level.m_46859_(blockPos) && !(state.m_60734_() instanceof AppleBlock)) {
                if (!level.f_46443_) {
                    BlockState blockState2 = (BlockState)((BlockState)((Block)COBlocks.RED_APPLE.get()).m_49966_().m_61124_((Property)AppleBlock.APPLES, (Comparable)Integer.valueOf(1))).m_61124_((Property)AppleBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
                    level.m_7731_(blockPos, blockState2, 3);
                    if (!player.m_7500_()) {
                        itemStack.m_41774_(1);
                    }
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            if (state.m_60734_() instanceof AppleBlock) {
                Property<Integer> property = ForgeEvent.getAppleProperty(state, "apples");
                if ((Integer)state.m_61143_(property) < 16) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(property, (Comparable)Integer.valueOf((Integer)state.m_61143_(property) + 1)));
                    RandomSource random = RandomSource.m_216327_();
                    level.m_245747_(pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 0.5f + 0.2f * random.m_188501_(), false);
                    if (!player.m_7500_()) {
                        itemStack.m_41774_(1);
                    }
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private static Property<Integer> getAppleProperty(BlockState state, String propertyName) {
        Block block = state.m_60734_();
        if (block instanceof AppleBlock) {
            for (Property prop : state.m_61147_()) {
                if (!(prop instanceof IntegerProperty) || !prop.m_61708_().equals(propertyName)) continue;
                return prop;
            }
        }
        return null;
    }
}

