/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.ridetogether.mixin;

import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin {
    @Shadow
    private float standAnimO;

    @Shadow
    protected abstract void doPlayerRide(Player var1);

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobInteract(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        AbstractHorse horse = (AbstractHorse)this;
        if (!horse.isTamed() && player.isCreative()) {
            horse.tameWithName(player);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
        if (horse.isVehicle()) {
            this.doPlayerRide(player);
            player.startRiding((Entity)horse, true);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, cancellable=true)
    @OnlyIn(value=Dist.CLIENT)
    protected void positionRider(Entity entity, Entity.MoveFunction moveFunction, CallbackInfo ci) {
        AbstractHorse abstractHorse;
        int passengerIndex;
        AbstractHorseMixin abstractHorseMixin = this;
        if (abstractHorseMixin instanceof AbstractHorse && (passengerIndex = (abstractHorse = (AbstractHorse)abstractHorseMixin).getPassengers().indexOf(entity)) == 1) {
            double baseY = abstractHorse.getPassengerRidingPosition((Entity)entity).y + (double)entity.getMyRidingOffset(entity);
            float yawRad = (float)Math.toRadians(-abstractHorse.getYRot());
            double backX = Math.sin(yawRad) * 0.5;
            double backZ = Math.cos(yawRad) * 0.5;
            double finalX = abstractHorse.getX() - backX;
            double finalZ = abstractHorse.getZ() - backZ;
            if (this.standAnimO > 0.0f) {
                float bodyYawRad = abstractHorse.yBodyRot * ((float)Math.PI / 180);
                float sinYaw = Mth.sin((float)bodyYawRad);
                float cosYaw = Mth.cos((float)bodyYawRad);
                float rearOffset = 0.7f * this.standAnimO;
                float heightOffset = 0.15f * this.standAnimO;
                finalX = abstractHorse.getX() + (double)(sinYaw * rearOffset) - backX;
                finalZ = abstractHorse.getZ() - (double)(cosYaw * rearOffset) - backZ;
                baseY += (double)heightOffset;
            }
            moveFunction.accept(entity, finalX, baseY, finalZ);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.yBodyRot = abstractHorse.yBodyRot;
            }
            ci.cancel();
        }
    }
}

