/*
 * Decompiled with CFR 0.152.
 */
package com.kltyton.name.push_forward.mixin;

import com.kltyton.name.push_forward.PushForward;
import com.kltyton.name.push_forward.config.ModConfig;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public class EntityMixin {
    @Unique
    private static final ModConfig CONFIG = ModConfig.load();
    @Unique
    private static final float DAMAGE_RATE_OF_MULTIPLICATION = EntityMixin.CONFIG.damageRateOfMultiplication;
    @Unique
    private static final double KNOCKBACK_RATE_OF_MULTIPLICATION = EntityMixin.CONFIG.knockbackRateOfMultiplication;
    @Unique
    private static final double VELOCITY_THRESHOLD = EntityMixin.CONFIG.velocityThreshold;
    @Unique
    private static final float MAX_DAMAGE = EntityMixin.CONFIG.maxDamage;
    @Unique
    private static final float MIN_DAMAGE = EntityMixin.CONFIG.minDamage;
    @Unique
    private static final double MAX_KNOCKBACK = EntityMixin.CONFIG.maxKnockback;
    @Unique
    private static final double MIN_KNOCKBACK = EntityMixin.CONFIG.minKnockback;
    @Unique
    private static final double HURT_BACK_RATE_OF_MULTIPLICATION = EntityMixin.CONFIG.hurtBackRateOfMultiplication;
    @Unique
    private static final boolean HURT_BACK = EntityMixin.CONFIG.hurtBack;
    @Unique
    private static final boolean BLACKLIST_ENABLED = EntityMixin.CONFIG.blackListEnabled;
    @Unique
    private static final boolean WHITELIST_ENABLED = EntityMixin.CONFIG.whiteListEnabled;
    @Unique
    private static final int KNOCKBACK_TICK_TIME = EntityMixin.CONFIG.knockbackTickTime;
    @Unique
    private static final List<String> BLACKLIST = EntityMixin.CONFIG.blackList;
    @Unique
    private static final List<String> WHITELIST = EntityMixin.CONFIG.whiteList;
    @Unique
    private int delayTicks = KNOCKBACK_TICK_TIME;
    @Unique
    private static final boolean SENSITIVE_MODE_ENABLED = EntityMixin.CONFIG.sensitiveModeEnabled;
    @Unique
    private static final double COLLISION_BOX_EXPANSION = EntityMixin.CONFIG.collisionBoxExpansion;
    @Shadow
    private class_1937 field_6002;
    @Unique
    private class_1297 pushedEntity = null;
    @Unique
    private static final class_2940<Boolean> IS_PUSHING = class_2945.method_12791(class_1297.class, (class_2941)class_2943.field_13323);
    @Unique
    private class_243 nextVelocity = null;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        class_1297 thisEntity = (class_1297)this;
        thisEntity.method_5841().method_12784(IS_PUSHING, (Object)false);
    }

    @Inject(method={"pushAwayFrom"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPushAwayFrom(@NotNull class_1297 entity, CallbackInfo ci) {
        if (!SENSITIVE_MODE_ENABLED) {
            double otherSpeed;
            class_1297 thisEntity = (class_1297)this;
            if (BLACKLIST_ENABLED && this.isInBlacklist(entity) || WHITELIST_ENABLED && this.isInWhitelist(entity) || entity instanceof class_1657) {
                ci.cancel();
                return;
            }
            class_243 thisVelocity = thisEntity.method_18798();
            class_243 otherVelocity = entity.method_18798();
            double thisSpeed = thisVelocity.method_1033() * 20.0;
            if (thisSpeed > (otherSpeed = otherVelocity.method_1033() * 20.0) && thisSpeed >= VELOCITY_THRESHOLD) {
                double relativeSpeed = thisSpeed - otherSpeed;
                float damage = (float)(relativeSpeed * (double)DAMAGE_RATE_OF_MULTIPLICATION);
                damage = Math.max(damage, MIN_DAMAGE);
                damage = Math.min(damage, MAX_DAMAGE);
                double knockback = relativeSpeed * KNOCKBACK_RATE_OF_MULTIPLICATION;
                knockback = Math.max(knockback, MIN_KNOCKBACK);
                knockback = Math.min(knockback, MAX_KNOCKBACK);
                entity.method_5643(PushForward.of(this.field_6002, PushForward.COLLIDE), damage);
                class_243 knockbackDirection = entity.method_19538().method_1020(thisEntity.method_19538()).method_1029();
                this.nextVelocity = new class_243(knockbackDirection.field_1352 * knockback, knockbackDirection.field_1351 * knockback, knockbackDirection.field_1350 * knockback);
                thisEntity.method_5841().method_12778(IS_PUSHING, (Object)true);
                if (HURT_BACK && !thisEntity.method_37908().method_18026(thisEntity.method_5829().method_1014(COLLISION_BOX_EXPANSION))) {
                    thisEntity.method_5643(PushForward.of(this.field_6002, PushForward.COLLIDE), (float)(thisSpeed * (double)DAMAGE_RATE_OF_MULTIPLICATION));
                    thisEntity.method_5762(knockbackDirection.field_1352 * knockback * HURT_BACK_RATE_OF_MULTIPLICATION, knockbackDirection.field_1351 * knockback * HURT_BACK_RATE_OF_MULTIPLICATION, knockbackDirection.field_1350 * knockback * HURT_BACK_RATE_OF_MULTIPLICATION);
                }
                this.pushedEntity = entity;
                ci.cancel();
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        class_1297 thisEntity = (class_1297)this;
        if (((Boolean)thisEntity.method_5841().method_12789(IS_PUSHING)).booleanValue()) {
            thisEntity.method_5841().method_12778(IS_PUSHING, (Object)false);
            if (this.delayTicks > 0) {
                --this.delayTicks;
                if (this.delayTicks > 0) {
                    return;
                }
            }
            if (this.pushedEntity != null && this.nextVelocity != null) {
                this.pushedEntity.method_5762(this.nextVelocity.field_1352, this.nextVelocity.field_1351, this.nextVelocity.field_1350);
                this.nextVelocity = null;
            }
        }
        if (SENSITIVE_MODE_ENABLED) {
            List collidingEntities = thisEntity.method_37908().method_8335(thisEntity, thisEntity.method_5829().method_1014(COLLISION_BOX_EXPANSION));
            for (class_1297 entity : collidingEntities) {
                double otherSpeed;
                if (BLACKLIST_ENABLED && this.isInBlacklist(entity) || WHITELIST_ENABLED && this.isInWhitelist(entity) || entity instanceof class_1657) continue;
                class_243 thisVelocity = thisEntity.method_18798();
                class_243 otherVelocity = entity.method_18798();
                double thisSpeed = thisVelocity.method_1033() * 20.0;
                if (!(thisSpeed > (otherSpeed = otherVelocity.method_1033() * 20.0)) || !(thisSpeed >= VELOCITY_THRESHOLD)) continue;
                double relativeSpeed = thisSpeed - otherSpeed;
                float damage = (float)(relativeSpeed * (double)DAMAGE_RATE_OF_MULTIPLICATION);
                damage = Math.max(damage, MIN_DAMAGE);
                damage = Math.min(damage, MAX_DAMAGE);
                double knockback = relativeSpeed * KNOCKBACK_RATE_OF_MULTIPLICATION;
                knockback = Math.max(knockback, MIN_KNOCKBACK);
                knockback = Math.min(knockback, MAX_KNOCKBACK);
                entity.method_5643(PushForward.of(this.field_6002, PushForward.COLLIDE), damage);
                class_243 knockbackDirection = entity.method_19538().method_1020(thisEntity.method_19538()).method_1029();
                this.nextVelocity = new class_243(knockbackDirection.field_1352 * knockback, knockbackDirection.field_1351 * knockback, knockbackDirection.field_1350 * knockback);
                thisEntity.method_5841().method_12778(IS_PUSHING, (Object)true);
                if (HURT_BACK && !thisEntity.method_37908().method_18026(thisEntity.method_5829().method_1014(COLLISION_BOX_EXPANSION))) {
                    thisEntity.method_5643(PushForward.of(this.field_6002, PushForward.COLLIDE), (float)(thisSpeed * (double)DAMAGE_RATE_OF_MULTIPLICATION));
                    thisEntity.method_5762(knockbackDirection.field_1352 * knockback * HURT_BACK_RATE_OF_MULTIPLICATION, knockbackDirection.field_1351 * knockback * HURT_BACK_RATE_OF_MULTIPLICATION, knockbackDirection.field_1350 * knockback * HURT_BACK_RATE_OF_MULTIPLICATION);
                }
                this.pushedEntity = entity;
            }
        }
    }

    @Unique
    private boolean isInBlacklist(class_1297 entity) {
        return BLACKLIST.contains(entity.method_5864().method_5882());
    }

    @Unique
    private boolean isInWhitelist(class_1297 entity) {
        return !WHITELIST.isEmpty() && !WHITELIST.contains(entity.method_5864().method_5882());
    }
}

