/*
 * Decompiled with CFR 0.152.
 */
package tfar.missingmodswarning;

import com.mojang.datafixers.DataFixer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tfar.missingmodswarning.MissingModsSummary;
import tfar.missingmodswarning.MissingModsWarning;
import tfar.missingmodswarning.datagen.ModDatagen;

@Mod(value="missingmodswarning")
public class MissingModsWarningForge {
    public static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/world_selection.png");

    public MissingModsWarningForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ModDatagen::start);
        MissingModsWarning.init();
    }

    public static void checkForIssues(LevelStorageSource.LevelDirectory pLevelDirectory, boolean pLocked, Path p289916, DataFixer p289917, CallbackInfoReturnable<LevelSummary> cir, CompoundTag var6) {
        LevelSummary original = (LevelSummary)cir.getReturnValue();
        if (original.getClass() == LevelSummary.class) {
            CompoundTag fmlTag = var6.m_128469_("fml");
            ListTag modList = fmlTag.m_128437_("LoadingModList", 10);
            HashMap<String, ArtifactVersion> missing = new HashMap<String, ArtifactVersion>(modList.size());
            HashMap<String, ArtifactVersion> mismatched = new HashMap<String, ArtifactVersion>(modList.size());
            for (int i = 0; i < modList.size(); ++i) {
                Tag tag = modList.get(i);
                CompoundTag mod = (CompoundTag)tag;
                String modId = mod.m_128461_("ModId");
                if (Objects.equals("minecraft", modId)) continue;
                String modVersion = mod.m_128461_("ModVersion");
                DefaultArtifactVersion previousVersion = new DefaultArtifactVersion(modVersion);
                ModList.get().getModContainerById(modId).ifPresentOrElse(container -> {
                    ArtifactVersion loadingVersion = container.getModInfo().getVersion();
                    if (!loadingVersion.equals(previousVersion)) {
                        mismatched.put(modId, (ArtifactVersion)previousVersion);
                    }
                }, () -> missing.put(modId, (ArtifactVersion)previousVersion));
            }
            if (!missing.isEmpty()) {
                cir.setReturnValue((Object)new MissingModsSummary(original.m_164913_(), original.m_78371_(), original.m_78358_(), original.m_193020_(), original.m_78375_(), original.m_246454_(), original.m_230875_(), missing, mismatched));
            }
        }
    }
}

