/*
 * Decompiled with CFR 0.152.
 */
package tfar.missingmodswarning.client;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import tfar.missingmodswarning.MissingModsSummary;
import tfar.missingmodswarning.ModComponents;
import tfar.missingmodswarning.client.SimpleModListWidget;

public class MissingModsWarningScreen
extends Screen {
    private MultiLineLabel message = MultiLineLabel.f_94331_;
    private final Screen parent;
    private final MissingModsSummary missingModsSummary;
    private final WorldSelectionList.WorldListEntry entry;
    private int textHeight;
    private final Path modsDir;
    int listHeight = 9;
    protected SimpleModListWidget list;
    protected List<SimpleModInfo> simpleModInfoList = new ArrayList<SimpleModInfo>();

    public MissingModsWarningScreen(Screen parentScreen, Component title, MissingModsSummary missingModsSummary, WorldSelectionList.WorldListEntry entry) {
        super(title);
        this.parent = parentScreen;
        this.missingModsSummary = missingModsSummary;
        this.entry = entry;
        this.modsDir = FMLPaths.MODSDIR.get();
        this.buildModInfo();
    }

    void buildModInfo() {
        for (Map.Entry<String, ArtifactVersion> entry : this.missingModsSummary.getMissing().entrySet()) {
            String modid = entry.getKey();
            ModContainer modContainer = ModList.get().getModContainerById(modid).orElse(null);
            String version = modContainer != null ? modContainer.getModInfo().getVersion().toString() : "[MISSING]";
            this.simpleModInfoList.add(new SimpleModInfo(entry.getKey(), entry.getValue().toString(), version));
        }
    }

    protected void m_7856_() {
        this.message = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)ModComponents.WORLD_MISSING_MODS, (int)(this.f_96543_ / 2));
        int listLeft = Math.max(8, this.f_96543_ / 2 - 220);
        int listWidth = Math.min(440, this.f_96543_ - 16);
        int margin = 52;
        int upperButtonHeight = this.f_96544_ - margin + 6;
        int lowerButtonHeight = this.f_96544_ - margin + 30;
        this.list = new SimpleModListWidget(this, this.f_96543_, margin + 16, this.f_96544_ - margin);
        int buttonWidth = Math.min(210, this.f_96543_ / 2 - 20);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130659_, this::loadAnyway).m_252987_(Math.max(this.f_96543_ / 4 - buttonWidth / 2, listLeft), upperButtonHeight, buttonWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"fml.button.open.mods.folder"), button -> Util.m_137581_().m_137644_(this.modsDir.toFile())).m_252987_(Math.min(this.f_96543_ * 3 / 4 - buttonWidth / 2, listLeft + listWidth - buttonWidth), upperButtonHeight, buttonWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_275759_, button -> this.f_96541_.m_91152_(this.parent)).m_252987_((this.f_96543_ - buttonWidth) / 2, lowerButtonHeight, buttonWidth, 20).m_253136_());
    }

    void loadAnyway(Button b) {
        this.f_96541_.m_91152_(this.parent);
        this.entry.m_101744_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int textYOffset = 18;
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, (this.f_96544_ - this.listHeight - this.textHeight) / 2 - textYOffset - 18, 0xAAAAAA);
        MutableComponent modidC = Component.m_237115_((String)"Modid").m_130940_(ChatFormatting.UNDERLINE);
        MutableComponent versionC = Component.m_237115_((String)"fml.modmismatchscreen.table.youhave").m_130940_(ChatFormatting.UNDERLINE);
        guiGraphics.m_280430_(this.f_96547_, (Component)modidC, 10, 50, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)ModComponents.SAVED_WITH, this.f_96543_ / 2, 50, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)versionC, (int)((double)this.f_96543_ * 0.75), 50, 0xFFFFFF);
        this.message.m_6514_(guiGraphics, this.f_96543_ / 2, 20, 30, 0xFF00FF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public static class SimpleModInfo {
        final String modid;
        final String oldVersion;
        final String version;

        public SimpleModInfo(String modid, String oldVersion, String version) {
            this.modid = modid;
            this.oldVersion = oldVersion;
            this.version = version;
        }
    }
}

