/*
 * Decompiled with CFR 0.152.
 */
package com.zenesta.morewaterlogged.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.zenesta.morewaterlogged.MoreWaterlogged;
import com.zenesta.morewaterlogged.common.map.ConversionMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConvertConfig {
    public static final File FILE = Paths.get(FMLPaths.CONFIGDIR.get().toString(), "morewaterlogged-map.json").toFile();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type REVIEW_TYPE = new TypeToken<Map<String, Map<String, Boolean>>>(){}.getType();

    public static void initialize() {
        if (!FILE.exists()) {
            ConvertConfig.createOrReplaceConfig();
            ConvertConfig.read();
        } else {
            ConvertConfig.read();
            ConvertConfig.createOrReplaceConfig();
        }
    }

    public static void read() {
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(FILE));
            Map loadedMapConfig = (Map)GSON.fromJson(reader, REVIEW_TYPE);
            if (loadedMapConfig != null && !loadedMapConfig.isEmpty()) {
                ConversionMap.CONFIG_MAP.putAll(loadedMapConfig);
            }
        }
        catch (FileNotFoundException e) {
            MoreWaterlogged.LOGGER.error("{} This shouldn't happen in at all.", (Object)e.getMessage());
            MoreWaterlogged.LOGGER.error((Object)e.getStackTrace());
        }
    }

    private static void createOrReplaceConfig() {
        Thread waitForDefaultConfig = new Thread(() -> {
            int i = 0;
            while (ConversionMap.HAS_INITIALIZED_LIST.size() != MoreWaterlogged.INSTALLED_SUPPORTED_MODS.size()) {
                if (i == 100000000) {
                    MoreWaterlogged.LOGGER.debug("Waiting for map initialization in mixin transformation.");
                    i = 0;
                }
                ++i;
            }
            if (ConversionMap.WILL_CREATE_CONFIG.get()) {
                MoreWaterlogged.LOGGER.debug("Config doesn't exist or is missing some entries. Creating one.");
                try {
                    FileWriter writer = new FileWriter(FILE);
                    FILE.createNewFile();
                    GSON.toJson(ConversionMap.CONFIG_MAP, (Appendable)writer);
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    MoreWaterlogged.LOGGER.error(e.getMessage());
                    MoreWaterlogged.LOGGER.error((Object)e.getStackTrace());
                }
            }
        }, "morewaterlogged-config-worker");
        waitForDefaultConfig.start();
    }
}

