/*
 * Decompiled with CFR 0.152.
 */
package com.zenesta.morewaterlogged.common.map;

import com.zenesta.morewaterlogged.MoreWaterlogged;
import com.zenesta.morewaterlogged.common.block.alchemistry.AtomizerBlock;
import com.zenesta.morewaterlogged.common.block.alchemistry.CombinerBlock;
import com.zenesta.morewaterlogged.common.block.alchemistry.CompactorBlock;
import com.zenesta.morewaterlogged.common.block.alchemistry.DissolverBlock;
import com.zenesta.morewaterlogged.common.block.alchemistry.LiquifierBlock;
import com.zenesta.morewaterlogged.common.map.ConversionMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;

public class AlchemistryConversionMap
extends ConversionMap {
    public static AlchemistryConversionMap instance = null;

    public AlchemistryConversionMap() {
        super("alchemistry");
        instance = this;
    }

    @Override
    public void initialize() {
        MoreWaterlogged.LOGGER.debug("Initializing blocks map for mod \"{}\"", (Object)this.modId);
        this.conversionMap.put("atomizer", props -> new AtomizerBlock());
        this.conversionMap.put("compactor", props -> new CompactorBlock());
        this.conversionMap.put("combiner", props -> new CombinerBlock());
        this.conversionMap.put("dissolver", props -> new DissolverBlock());
        this.conversionMap.put("liquifier", props -> new LiquifierBlock());
        this.postInitialize(this.conversionMap.keySet());
    }

    public Supplier<Block> convert(String key, Supplier<Block> sup) {
        if (this.conversionMap.containsKey(key)) {
            this.log(key);
            if (this.isKeyEnabled(key)) {
                return () -> (Block)((Function)this.conversionMap.get(key)).apply(null);
            }
        }
        return sup;
    }
}

