/*
 * Decompiled with CFR 0.152.
 */
package com.zenesta.morewaterlogged.common.map;

import com.zenesta.morewaterlogged.MoreWaterlogged;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public abstract class ConversionMap {
    public static final Map<String, Map<String, Boolean>> CONFIG_MAP = new LinkedHashMap<String, Map<String, Boolean>>();
    public static final List<Boolean> HAS_INITIALIZED_LIST = Collections.synchronizedList(new ArrayList());
    public static final AtomicBoolean WILL_CREATE_CONFIG = new AtomicBoolean(false);
    public Boolean hasInitialized = false;
    public String modId = "";
    public final Map<String, Function<BlockBehaviour.Properties, SimpleWaterloggedBlock>> conversionMap = new LinkedHashMap<String, Function<BlockBehaviour.Properties, SimpleWaterloggedBlock>>();

    public ConversionMap(String modId) {
        this.modId = modId;
        this.initialize();
    }

    protected abstract void initialize();

    protected void log(String key) {
        if (this.isKeyEnabled(key)) {
            MoreWaterlogged.LOGGER.debug("Key \"{}\" matched. Replacing that block with waterlogged counterpart.", (Object)key);
        } else {
            MoreWaterlogged.LOGGER.debug("Key \"{}\" matched but is disabled. Skip the replacement.", (Object)key);
        }
    }

    protected boolean isKeyEnabled(String key) {
        return CONFIG_MAP.get(this.modId).containsKey(key) && CONFIG_MAP.get(this.modId).get(key) != false;
    }

    protected void postInitialize(Set<String> keys) {
        if (!CONFIG_MAP.containsKey(this.modId)) {
            CONFIG_MAP.put(this.modId, new LinkedHashMap());
        }
        for (String key : keys) {
            if (CONFIG_MAP.get(this.modId).containsKey(key)) continue;
            MoreWaterlogged.LOGGER.debug("[{}] key {} is not in the config file. Adding one.", (Object)this.modId, (Object)key);
            WILL_CREATE_CONFIG.set(true);
            CONFIG_MAP.get(this.modId).put(key, true);
        }
        HAS_INITIALIZED_LIST.add(true);
        this.hasInitialized = true;
    }
}

