/*
 * Decompiled with CFR 0.152.
 */
package com.zenesta.morewaterlogged.common.map;

import com.google.common.collect.ImmutableMap;
import com.zenesta.morewaterlogged.MoreWaterlogged;
import com.zenesta.morewaterlogged.common.block.minecraft.AnvilBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.BannerBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.BedBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.BellBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.BrewingStandBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.DoorBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.EnchantmentTableBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.GrindstoneBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.HopperBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.JukeboxBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.LecternBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.NetherPortalBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.StonecutterBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.WallBannerBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.compat.ApothAnvilBlock;
import com.zenesta.morewaterlogged.common.block.minecraft.compat.ApothEnchantBlock;
import com.zenesta.morewaterlogged.common.map.ConversionMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public class MinecraftConversionMap
extends ConversionMap {
    public static MinecraftConversionMap instance = null;
    private final Map<BlockSetType, Supplier<Block>> mapMaterial = ImmutableMap.of((Object)BlockSetType.f_271198_, () -> Blocks.f_50705_, (Object)BlockSetType.f_271100_, () -> Blocks.f_50741_, (Object)BlockSetType.f_271387_, () -> Blocks.f_50742_, (Object)BlockSetType.f_271187_, () -> Blocks.f_50743_, (Object)BlockSetType.f_271512_, () -> Blocks.f_50744_, (Object)BlockSetType.f_271401_, () -> Blocks.f_271304_, (Object)BlockSetType.f_271528_, () -> Blocks.f_50745_, (Object)BlockSetType.f_271383_, () -> Blocks.f_220865_, (Object)BlockSetType.f_271088_, () -> Blocks.f_244477_);

    public MinecraftConversionMap() {
        super("minecraft");
        instance = this;
    }

    @Override
    public void initialize() {
        this.conversionMap.put("white_bed", props -> this.bed(DyeColor.WHITE));
        this.conversionMap.put("orange_bed", props -> this.bed(DyeColor.ORANGE));
        this.conversionMap.put("magenta_bed", props -> this.bed(DyeColor.MAGENTA));
        this.conversionMap.put("light_blue_bed", props -> this.bed(DyeColor.LIGHT_BLUE));
        this.conversionMap.put("yellow_bed", props -> this.bed(DyeColor.YELLOW));
        this.conversionMap.put("lime_bed", props -> this.bed(DyeColor.LIME));
        this.conversionMap.put("pink_bed", props -> this.bed(DyeColor.PINK));
        this.conversionMap.put("gray_bed", props -> this.bed(DyeColor.GRAY));
        this.conversionMap.put("light_gray_bed", props -> this.bed(DyeColor.LIGHT_GRAY));
        this.conversionMap.put("cyan_bed", props -> this.bed(DyeColor.CYAN));
        this.conversionMap.put("purple_bed", props -> this.bed(DyeColor.PURPLE));
        this.conversionMap.put("blue_bed", props -> this.bed(DyeColor.BLUE));
        this.conversionMap.put("brown_bed", props -> this.bed(DyeColor.BROWN));
        this.conversionMap.put("green_bed", props -> this.bed(DyeColor.GREEN));
        this.conversionMap.put("red_bed", props -> this.bed(DyeColor.RED));
        this.conversionMap.put("black_bed", props -> this.bed(DyeColor.BLACK));
        this.conversionMap.put("white_banner", props -> this.banner(DyeColor.WHITE));
        this.conversionMap.put("orange_banner", props -> this.banner(DyeColor.ORANGE));
        this.conversionMap.put("magenta_banner", props -> this.banner(DyeColor.MAGENTA));
        this.conversionMap.put("light_blue_banner", props -> this.banner(DyeColor.LIGHT_BLUE));
        this.conversionMap.put("yellow_banner", props -> this.banner(DyeColor.YELLOW));
        this.conversionMap.put("lime_banner", props -> this.banner(DyeColor.LIME));
        this.conversionMap.put("pink_banner", props -> this.banner(DyeColor.PINK));
        this.conversionMap.put("gray_banner", props -> this.banner(DyeColor.GRAY));
        this.conversionMap.put("light_gray_banner", props -> this.banner(DyeColor.LIGHT_GRAY));
        this.conversionMap.put("cyan_banner", props -> this.banner(DyeColor.CYAN));
        this.conversionMap.put("purple_banner", props -> this.banner(DyeColor.PURPLE));
        this.conversionMap.put("blue_banner", props -> this.banner(DyeColor.BLUE));
        this.conversionMap.put("brown_banner", props -> this.banner(DyeColor.BROWN));
        this.conversionMap.put("green_banner", props -> this.banner(DyeColor.GREEN));
        this.conversionMap.put("red_banner", props -> this.banner(DyeColor.RED));
        this.conversionMap.put("black_banner", props -> this.banner(DyeColor.BLACK));
        this.conversionMap.put("white_wall_banner", props -> this.wallBanner(DyeColor.WHITE, Blocks.f_50414_));
        this.conversionMap.put("orange_wall_banner", props -> this.wallBanner(DyeColor.ORANGE, Blocks.f_50415_));
        this.conversionMap.put("magenta_wall_banner", props -> this.wallBanner(DyeColor.MAGENTA, Blocks.f_50416_));
        this.conversionMap.put("light_blue_wall_banner", props -> this.wallBanner(DyeColor.LIGHT_BLUE, Blocks.f_50417_));
        this.conversionMap.put("yellow_wall_banner", props -> this.wallBanner(DyeColor.YELLOW, Blocks.f_50418_));
        this.conversionMap.put("lime_wall_banner", props -> this.wallBanner(DyeColor.LIME, Blocks.f_50419_));
        this.conversionMap.put("pink_wall_banner", props -> this.wallBanner(DyeColor.PINK, Blocks.f_50420_));
        this.conversionMap.put("gray_wall_banner", props -> this.wallBanner(DyeColor.GRAY, Blocks.f_50421_));
        this.conversionMap.put("light_gray_wall_banner", props -> this.wallBanner(DyeColor.LIGHT_GRAY, Blocks.f_50422_));
        this.conversionMap.put("cyan_wall_banner", props -> this.wallBanner(DyeColor.CYAN, Blocks.f_50423_));
        this.conversionMap.put("purple_wall_banner", props -> this.wallBanner(DyeColor.PURPLE, Blocks.f_50424_));
        this.conversionMap.put("blue_wall_banner", props -> this.wallBanner(DyeColor.BLUE, Blocks.f_50425_));
        this.conversionMap.put("brown_wall_banner", props -> this.wallBanner(DyeColor.BROWN, Blocks.f_50426_));
        this.conversionMap.put("green_wall_banner", props -> this.wallBanner(DyeColor.GREEN, Blocks.f_50427_));
        this.conversionMap.put("red_wall_banner", props -> this.wallBanner(DyeColor.RED, Blocks.f_50428_));
        this.conversionMap.put("black_wall_banner", props -> this.wallBanner(DyeColor.BLACK, Blocks.f_50429_));
        this.conversionMap.put("anvil", props -> this.anvil());
        this.conversionMap.put("chipped_anvil", props -> this.anvil());
        this.conversionMap.put("damaged_anvil", props -> this.anvil());
        this.conversionMap.put("bell", props -> this.bell());
        this.conversionMap.put("brewing_stand", props -> this.brewingStand());
        this.conversionMap.put("enchanting_table", props -> this.enchantmentTable());
        this.conversionMap.put("grindstone", props -> this.grindstone());
        this.conversionMap.put("hopper", props -> this.hopper());
        this.conversionMap.put("lectern", props -> this.lectern());
        this.conversionMap.put("jukebox", props -> this.jukebox());
        this.conversionMap.put("nether_portal", props -> this.netherPortal());
        this.conversionMap.put("stonecutter", props -> this.stonecutter());
        this.conversionMap.put("oak_door", props -> this.door(BlockSetType.f_271198_));
        this.conversionMap.put("iron_door", props -> this.door(BlockSetType.f_271132_));
        this.conversionMap.put("spruce_door", props -> this.door(BlockSetType.f_271100_));
        this.conversionMap.put("birch_door", props -> this.door(BlockSetType.f_271387_));
        this.conversionMap.put("jungle_door", props -> this.door(BlockSetType.f_271187_));
        this.conversionMap.put("acacia_door", props -> this.door(BlockSetType.f_271512_));
        this.conversionMap.put("cherry_door", props -> this.door(BlockSetType.f_271401_));
        this.conversionMap.put("dark_oak_door", props -> this.door(BlockSetType.f_271528_));
        this.conversionMap.put("mangrove_door", props -> this.door(BlockSetType.f_271383_));
        this.conversionMap.put("bamboo_door", props -> this.door(BlockSetType.f_271088_));
        this.applyCompatibility();
        this.postInitialize(this.conversionMap.keySet());
    }

    public Block convert(String key, Block block) {
        if (this.conversionMap.containsKey(key)) {
            this.log(key);
            if (this.isKeyEnabled(key)) {
                Registry.m_122961_((Registry)BuiltInRegistries.f_256975_, (String)(key + "_deprecated"), (Object)block);
                return (Block)((Function)this.conversionMap.get(key)).apply(null);
            }
        }
        return block;
    }

    public void applyCompatibility() {
        List<String> modList = LoadingModList.get().getMods().stream().map(ModInfo::getModId).toList();
        if (modList.contains("apotheosis")) {
            MoreWaterlogged.LOGGER.debug("Apply compatible registry with \"apotheosis\"");
            this.conversionMap.replace("anvil", props -> new ApothAnvilBlock());
            this.conversionMap.replace("chipped_anvil", props -> new ApothAnvilBlock());
            this.conversionMap.replace("damaged_anvil", props -> new ApothAnvilBlock());
            this.conversionMap.replace("enchanting_table", props -> new ApothEnchantBlock());
        }
    }

    private BedBlock bed(DyeColor pColor) {
        return new BedBlock(pColor, BlockBehaviour.Properties.m_284310_().m_284495_(p_284863_ -> p_284863_.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT ? pColor.m_284406_() : MapColor.f_283930_).m_60918_(SoundType.f_56736_).m_60978_(0.2f).m_60955_().m_278183_().m_278166_(PushReaction.DESTROY));
    }

    private BannerBlock banner(DyeColor pColor) {
        return new BannerBlock(pColor, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_278183_());
    }

    private WallBannerBlock wallBanner(DyeColor pColor, Block standingBanner) {
        return new WallBannerBlock(pColor, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_60916_(standingBanner).m_278183_());
    }

    private AnvilBlock anvil() {
        return new AnvilBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60913_(5.0f, 1200.0f).m_60918_(SoundType.f_56749_).m_278166_(PushReaction.BLOCK));
    }

    private BellBlock bell() {
        return new BellBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_280606_().m_60999_().m_60978_(5.0f).m_60918_(SoundType.f_56749_).m_278166_(PushReaction.DESTROY));
    }

    private BrewingStandBlock brewingStand() {
        return new BrewingStandBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60978_(0.5f).m_60953_(p_50872_ -> 1).m_60955_());
    }

    private EnchantmentTableBlock enchantmentTable() {
        return new EnchantmentTableBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60953_(p_50874_ -> 7).m_60913_(5.0f, 1200.0f));
    }

    private GrindstoneBlock grindstone() {
        return new GrindstoneBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56742_).m_278166_(PushReaction.BLOCK));
    }

    private HopperBlock hopper() {
        return new HopperBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60913_(3.0f, 4.8f).m_60918_(SoundType.f_56743_).m_60955_());
    }

    private LecternBlock lectern() {
        return new LecternBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_278183_());
    }

    private NetherPortalBlock netherPortal() {
        return new NetherPortalBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_60977_().m_60978_(-1.0f).m_60918_(SoundType.f_56744_).m_60953_(p_152605_ -> 11).m_278166_(PushReaction.BLOCK));
    }

    private StonecutterBlock stonecutter() {
        return new StonecutterBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60978_(3.5f));
    }

    private DoorBlock door(BlockSetType type) {
        if (type == BlockSetType.f_271132_) {
            return new DoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60978_(5.0f).m_60955_().m_278166_(PushReaction.DESTROY), type);
        }
        if (this.mapMaterial.containsKey(type)) {
            return new DoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(this.mapMaterial.get(type).get().m_284356_()).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_278183_().m_278166_(PushReaction.DESTROY), type);
        }
        throw new RuntimeException("Mismatching door type");
    }

    private JukeboxBlock jukebox() {
        return new JukeboxBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 6.0f).m_278183_());
    }
}

