/*
 * Decompiled with CFR 0.152.
 */
package com.zenesta.morewaterlogged.mixin.generic;

import com.zenesta.morewaterlogged.common.map.AlchemistryConversionMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DeferredRegister.class})
public class MixinDeferredRegister<T> {
    @Shadow(remap=false)
    @Final
    private ResourceKey<? extends Registry<T>> registryKey;
    @Shadow(remap=false)
    @Final
    private String modid;
    @Shadow(remap=false)
    @Final
    private Map<RegistryObject<T>, Supplier<? extends T>> entries;
    @Shadow(remap=false)
    @Final
    private boolean optionalRegistry;
    @Shadow(remap=false)
    private boolean seenRegisterEvent;

    @Inject(method={"<init>*"}, at={@At(value="TAIL")})
    private void staticHead(CallbackInfo ci) {
        if (AlchemistryConversionMap.instance == null) {
            new AlchemistryConversionMap();
        }
    }

    @Overwrite(remap=false)
    public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> sup) {
        if (this.registryKey.equals((Object)ForgeRegistries.BLOCKS.getRegistryKey()) && this.modid.equals("alchemistry")) {
            sup = AlchemistryConversionMap.instance.convert(name, sup);
        }
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after RegisterEvent has been fired.");
        }
        Objects.requireNonNull(name);
        Objects.requireNonNull(sup);
        ResourceLocation key = new ResourceLocation(this.modid, name);
        if (this.registryKey != null) {
            RegistryObject ret;
            RegistryObject registryObject = ret = this.optionalRegistry ? RegistryObject.createOptional((ResourceLocation)key, this.registryKey, (String)this.modid) : RegistryObject.create((ResourceLocation)key, this.registryKey, (String)this.modid);
            if (this.entries.putIfAbsent(ret, sup) != null) {
                throw new IllegalArgumentException("Duplicate registration " + name);
            }
            return ret;
        }
        throw new IllegalStateException("Could not create RegistryObject in DeferredRegister");
    }
}

