/*
 * Decompiled with CFR 0.152.
 */
package splat.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import splat.entity.BubbleEntityEntity;
import splat.entity.SpitSplatEntity;
import splat.entity.SplatterRangedProjectileEntity;
import splat.entity.WaterShockwaveEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SplatModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"splat");
    public static final RegistryObject<EntityType<SpitSplatEntity>> SPIT_SPLAT = SplatModEntities.register("spit_splat", EntityType.Builder.m_20704_(SpitSplatEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SpitSplatEntity::new).m_20699_(0.8f, 0.9f));
    public static final RegistryObject<EntityType<BubbleEntityEntity>> BUBBLE_ENTITY = SplatModEntities.register("bubble_entity", EntityType.Builder.m_20704_(BubbleEntityEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BubbleEntityEntity::new).m_20719_().m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<WaterShockwaveEntity>> WATER_SHOCKWAVE = SplatModEntities.register("water_shockwave", EntityType.Builder.m_20704_(WaterShockwaveEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(WaterShockwaveEntity::new).m_20719_().m_20699_(1.0f, 1.0f));
    public static final RegistryObject<EntityType<SplatterRangedProjectileEntity>> SPLATTER_RANGED_PROJECTILE = SplatModEntities.register("projectile_splatter_ranged_projectile", EntityType.Builder.m_20704_(SplatterRangedProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(SplatterRangedProjectileEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SpitSplatEntity.init();
            BubbleEntityEntity.init();
            WaterShockwaveEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SPIT_SPLAT.get(), SpitSplatEntity.createAttributes().m_22265_());
        event.put((EntityType)BUBBLE_ENTITY.get(), BubbleEntityEntity.createAttributes().m_22265_());
        event.put((EntityType)WATER_SHOCKWAVE.get(), WaterShockwaveEntity.createAttributes().m_22265_());
    }
}

