/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.block;

import dev.dh.arthropocolypse.entity.Stag_Beetle;
import dev.dh.arthropocolypse.init.APEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class Stag_Beetle_Egg_Block
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final int MIN_EGGS = 1;
    public static final int MAX_EGGS = 4;
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final IntegerProperty EGGS = BlockStateProperties.f_61415_;
    protected static final VoxelShape AABB_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    protected static final VoxelShape AABB_DOWN = Block.m_49796_((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape AABB_EAST = Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0);
    protected static final VoxelShape AABB_WEST = Block.m_49796_((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    protected static final VoxelShape AABB_SOUTH = Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0);
    protected static final VoxelShape AABB_NORTH = Block.m_49796_((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0);

    public Stag_Beetle_Egg_Block(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void m_6807_(BlockState p_57814_, Level p_57815_, BlockPos p_57816_, BlockState p_57817_, boolean p_57818_) {
        if (Stag_Beetle_Egg_Block.canLayEgg((BlockGetter)p_57815_, p_57816_) && !p_57815_.f_46443_) {
            p_57815_.m_46796_(2005, p_57816_, 0);
        }
    }

    public void m_6240_(Level p_57771_, Player p_57772_, BlockPos p_57773_, BlockState p_57774_, @javax.annotation.Nullable BlockEntity p_57775_, ItemStack p_57776_) {
        super.m_6240_(p_57771_, p_57772_, p_57773_, p_57774_, p_57775_, p_57776_);
        this.decreaseEggs(p_57771_, p_57773_, p_57774_);
    }

    public boolean m_6864_(BlockState p_57796_, BlockPlaceContext p_57797_) {
        return !p_57797_.m_7078_() && p_57797_.m_43722_().m_150930_(this.m_5456_()) && (Integer)p_57796_.m_61143_((Property)EGGS) < 4 || super.m_6864_(p_57796_, p_57797_);
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (!entity.m_20161_()) {
            this.destroyEgg(level, blockState, blockPos, entity, 100);
        }
        super.m_141947_(level, blockPos, blockState, entity);
    }

    public void m_142072_(Level p_154845_, BlockState p_154846_, BlockPos p_154847_, Entity p_154848_, float p_154849_) {
        if (!(p_154848_ instanceof Zombie)) {
            this.destroyEgg(p_154845_, p_154846_, p_154847_, p_154848_, 3);
        }
        super.m_142072_(p_154845_, p_154846_, p_154847_, p_154848_, p_154849_);
    }

    private void destroyEgg(Level level, BlockState blockState, BlockPos blockPos, Entity entity, int random) {
        if (this.canDestroyEgg(level, entity) && !level.f_46443_ && level.f_46441_.m_188503_(random) == 0 && blockState.m_60713_(Blocks.f_50578_)) {
            this.decreaseEggs(level, blockPos, blockState);
        }
    }

    private void decreaseEggs(Level p_57792_, BlockPos p_57793_, BlockState p_57794_) {
        p_57792_.m_5594_(null, p_57793_, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + p_57792_.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)p_57794_.m_61143_((Property)EGGS);
        if (i <= 1) {
            p_57792_.m_46961_(p_57793_, false);
        } else {
            p_57792_.m_7731_(p_57793_, (BlockState)p_57794_.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            p_57792_.m_220407_(GameEvent.f_157794_, p_57793_, GameEvent.Context.m_223722_((BlockState)p_57794_));
            p_57792_.m_46796_(2001, p_57793_, Block.m_49956_((BlockState)p_57794_));
        }
    }

    private boolean canDestroyEgg(Level p_57768_, Entity p_57769_) {
        if (!(p_57769_ instanceof Stag_Beetle) && !(p_57769_ instanceof Bat)) {
            if (!(p_57769_ instanceof LivingEntity)) {
                return false;
            }
            return p_57769_ instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)p_57768_, (Entity)p_57769_);
        }
        return false;
    }

    public void m_213898_(BlockState p_222644_, ServerLevel p_222645_, BlockPos p_222646_, RandomSource p_222647_) {
        if (this.shouldUpdateHatchLevel((Level)p_222645_) && Stag_Beetle_Egg_Block.canLayEgg((BlockGetter)p_222645_, p_222646_)) {
            int i = (Integer)p_222644_.m_61143_((Property)HATCH);
            if (i < 2) {
                p_222645_.m_5594_(null, p_222646_, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + p_222647_.m_188501_() * 0.2f);
                p_222645_.m_7731_(p_222646_, (BlockState)p_222644_.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                p_222645_.m_5594_(null, p_222646_, SoundEvents.f_12535_, SoundSource.BLOCKS, 0.7f, 0.9f + p_222647_.m_188501_() * 0.2f);
                p_222645_.m_7471_(p_222646_, false);
                for (int j = 0; j < (Integer)p_222644_.m_61143_((Property)EGGS); ++j) {
                    p_222645_.m_46796_(2001, p_222646_, Block.m_49956_((BlockState)p_222644_));
                    Stag_Beetle beetle = (Stag_Beetle)((EntityType)APEntityInit.STAG_BEETLE.get()).m_20615_((Level)p_222645_);
                    if (beetle == null) continue;
                    beetle.m_146762_(-24000);
                    beetle.m_7678_((double)p_222646_.m_123341_() + 0.3 + (double)j * 0.2, p_222646_.m_123342_(), (double)p_222646_.m_123343_() + 0.3, 0.0f, 0.0f);
                    p_222645_.m_7967_((Entity)beetle);
                }
            }
        }
    }

    private boolean shouldUpdateHatchLevel(Level p_57766_) {
        float f = p_57766_.m_46942_(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return p_57766_.f_46441_.m_188503_(500) == 0;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState blockstate = this.m_49966_();
        for (Direction direction : context.m_6232_()) {
            Direction oppositeDirection = direction.m_122424_();
            if (!(blockstate = (BlockState)blockstate.m_61124_((Property)f_52588_, (Comparable)oppositeDirection)).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos blockPos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> AABB_UP;
            case Direction.DOWN -> AABB_DOWN;
            case Direction.EAST -> AABB_EAST;
            case Direction.WEST -> AABB_WEST;
            case Direction.SOUTH -> AABB_SOUTH;
            case Direction.NORTH -> AABB_NORTH;
        };
    }

    public BlockState m_7417_(BlockState p_60541_, Direction p_60542_, BlockState p_60543_, LevelAccessor p_60544_, BlockPos p_60545_, BlockPos p_60546_) {
        return !this.m_7898_(p_60541_, (LevelReader)p_60544_, p_60545_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_60541_, p_60542_, p_60543_, p_60544_, p_60545_, p_60546_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, BlockStateProperties.f_61362_, HATCH, EGGS});
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos blockPos) {
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        BlockPos relativePos = blockPos.m_121945_(direction.m_122424_());
        BlockState blockState = levelReader.m_8055_(relativePos);
        return blockState.m_60783_((BlockGetter)levelReader, relativePos, direction);
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public static boolean canLayEgg(BlockGetter p_57763_, BlockPos p_57764_) {
        return Stag_Beetle_Egg_Block.isBlock(p_57763_, p_57764_.m_7495_());
    }

    public static boolean isBlock(BlockGetter p_57801_, BlockPos p_57802_) {
        return p_57801_.m_8055_(p_57802_).m_204336_(BlockTags.f_13106_) || p_57801_.m_8055_(p_57802_).m_204336_(BlockTags.f_144274_);
    }
}

