/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public abstract class LanguageDataProvider
implements DataProvider {
    private final Map<Language, Map<String, String>> languageMap = new TreeMap<Language, Map<String, String>>();
    private final PackOutput output;
    private final String modid;

    public LanguageDataProvider(PackOutput output, String modId) {
        this.output = output;
        this.modid = modId;
    }

    public void add(Language language, String key, String value) {
        Map data = this.languageMap.getOrDefault((Object)language, new TreeMap());
        if (data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
        this.languageMap.put(language, data);
    }

    public void add(Language language, Block key, String name) {
        this.add(language, key.m_7705_(), name);
    }

    public void add(Language language, Item key, String name) {
        this.add(language, key.m_5524_(), name);
    }

    public void add(Language language, ItemStack key, String name) {
        this.add(language, key.m_41778_(), name);
    }

    public void add(Language language, MobEffect key, String name) {
        this.add(language, key.m_19481_(), name);
    }

    public void add(Language language, Enchantment key, String name) {
        this.add(language, key.m_44704_(), name);
    }

    public void add(Language language, EntityType<?> key, String name) {
        this.add(language, key.m_20675_(), name);
    }

    public void addItem(Language language, Supplier<? extends Item> key, String name) {
        this.add(language, key.get(), name);
    }

    public void addBlock(Language language, Supplier<? extends Block> key, String name) {
        this.add(language, key.get(), name);
    }

    public void addItemStack(Language language, Supplier<ItemStack> key, String name) {
        this.add(language, key.get(), name);
    }

    public void addEnchantment(Language language, Supplier<? extends Enchantment> key, String name) {
        this.add(language, key.get(), name);
    }

    public void addEffect(Language language, Supplier<? extends MobEffect> key, String name) {
        this.add(language, key.get(), name);
    }

    public void addEntityType(Language language, Supplier<? extends EntityType<?>> key, String name) {
        this.add(language, key.get(), name);
    }

    public void addSubtitle(Language language, Supplier<SoundEvent> soundEventSupplier, String value) {
        this.add(language, "sounds.experienceextra." + soundEventSupplier.get().m_11660_().m_135815_(), value);
    }

    public void addAdvancement(Language language, ResourceLocation advancementId, String name, String advancementDescription) {
        this.add(language, "advancements.experienceextra." + advancementId.m_135815_() + ".title", name);
        this.add(language, "advancements.experienceextra." + advancementId.m_135815_() + ".description", advancementDescription);
    }

    protected abstract void addTranslations();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addTranslations();
        ArrayList tasks = new ArrayList();
        if (!this.languageMap.isEmpty()) {
            this.languageMap.forEach((lang, data) -> {
                JsonObject json = new JsonObject();
                Objects.requireNonNull(json);
                data.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
                tasks.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(this.modid).resolve("lang").resolve(lang.id + ".json")));
            });
        }
        return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0]));
    }

    @NotNull
    public String m_6055_() {
        return "Language Provider";
    }

    public static enum Language {
        ARABIC("ar"),
        ALBANIAN("sq"),
        BULGARIAN("bg_BG"),
        CATALAN("ca"),
        CHINESE_SIMPLIFIED("zh_CN"),
        CHINESE_TRADITIONAL("zh_TW"),
        CROATIAN("hr"),
        CZECH("cs_CZ"),
        DANISH("da_DK"),
        DUTCH("nl_NL"),
        ENGLISH("en_us"),
        FINNISH("fi"),
        FRENCH("fr_FR"),
        GERMAN("de_DE"),
        GREEK("el"),
        HEBREW("he_IL"),
        HUNGARIAN("hu_HU"),
        INDONESIAN("id_ID"),
        ITALIAN("it_IT"),
        JAPANESE("ja"),
        KOREAN("ko_KR"),
        NORWEGIAN("nb_NO"),
        PERSIAN("fa_IR"),
        POLISH("pl_PL"),
        PORTUGUESE("pt_PT"),
        ROMANIAN("ro_RO"),
        RUSSIAN("ru_ru"),
        SLOVENIAN("sl_SI"),
        SPANISH("es_ES"),
        SWEDISH("sv_SE"),
        THAI("th"),
        TURKISH("tr_TR"),
        UKRAINIAN("uk");

        private String id;

        private Language(String id) {
            this.id = id;
        }
    }
}

