/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.datagen;

import dev.dh.arthropocolypse.init.APBlockInit;
import dev.dh.arthropocolypse.init.APItemInit;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "arthropocolypse", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(APItemInit.BEETLE_FRAGMENT);
        this.simpleItem(APItemInit.STAG_BEETLE_EGG);
        this.simpleItem(APItemInit.FIELD_CRICKET_EGG);
        this.simpleItem(APItemInit.MEALWORM_EGG);
        this.simpleItem(APItemInit.GILDED_SCALE);
        this.simpleItem(APItemInit.MANDIBLE_PART);
        this.simpleItem(APItemInit.GILDED_ORGAN);
        this.simpleItem(APItemInit.SCARAB);
        this.simpleItem(APItemInit.ENERGY_BAR);
        this.simpleItem(APItemInit.ICE_CRAWLER_MEAT);
        this.simpleItem(APItemInit.COOKED_ICE_CRAWLER_MEAT);
        this.simpleItem(APItemInit.MANDIBLE_SHEAR);
        this.simpleItem(APItemInit.CARROT_PIECE);
        this.simpleItem(APItemInit.STAG_BEETLE_LARVA);
        this.simpleItem(APItemInit.MEALWORM);
        this.evenSimplerBlockItem(APBlockInit.BEETLE_FRAGMENT_BLOCK_STAIRS);
        this.evenSimplerBlockItem(APBlockInit.BEETLE_FRAGMENT_BLOCK_BRICKS_STAIRS);
        this.evenSimplerBlockItem(APBlockInit.POLISHED_BEETLE_FRAGMENT_BLOCK_STAIRS);
        this.evenSimplerBlockItem(APBlockInit.TILED_BEETLE_FRAGMENT_BLOCK_STAIRS);
        this.evenSimplerBlockItem(APBlockInit.BEETLE_FRAGMENT_BLOCK_SLABS);
        this.evenSimplerBlockItem(APBlockInit.BEETLE_FRAGMENT_BLOCK_BRICKS_SLABS);
        this.evenSimplerBlockItem(APBlockInit.POLISHED_BEETLE_FRAGMENT_BLOCK_SLABS);
        this.evenSimplerBlockItem(APBlockInit.TILED_BEETLE_FRAGMENT_BLOCK_SLABS);
        this.wallItem(APBlockInit.BEETLE_FRAGMENT_BLOCK_WALL, APBlockInit.BEETLE_FRAGMENT_BLOCK);
        this.wallItem(APBlockInit.BEETLE_FRAGMENT_BLOCK_BRICKS_WALL, APBlockInit.BEETLE_FRAGMENT_BLOCK_BRICKS);
        this.wallItem(APBlockInit.POLISHED_BEETLE_FRAGMENT_BLOCK_WALL, APBlockInit.POLISHED_BEETLE_FRAGMENT_BLOCK);
        this.wallItem(APBlockInit.TILED_BEETLE_FRAGMENT_BLOCK_WALL, APBlockInit.TILED_BEETLE_FRAGMENT_BLOCK);
        this.handheldItem(APItemInit.GILDED_DOUBLE_HEAD_AXE);
        this.handheldItem(APItemInit.MANDIBLE_DAGGER);
        this.simpleItemWithSuffix(APItemInit.GILDED_SCALE_ELYTRA, "broken");
        this.simpleItem(APItemInit.GILDED_SCALE_ELYTRA).override().model((ModelFile)this.getModel(APItemInit.GILDED_SCALE_ELYTRA, "broken")).predicate(new ResourceLocation("broken"), 1.0f).end();
        this.trimmedArmorItem(APItemInit.BEETLE_HELMET);
        this.trimmedArmorItem(APItemInit.BEETLE_CHESTPLATE);
        this.trimmedArmorItem(APItemInit.BEETLE_LEGGINGS);
        this.trimmedArmorItem(APItemInit.BEETLE_BOOTS);
        this.withExistingParent(APItemInit.BEHEMOTH_DESERT_SCORPION_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.PRAIRIE_GRASSHOPPER_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.FIELD_CRICKET_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.ICE_CRAWLER_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.BEHEMOTH_DESERT_SPIDER_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.SCARAB_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.WORKER_ANT_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.SOLDIER_ANT_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.STAG_BEETLE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.WHARF_ROACH_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.PLATERODRILUS_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.MEALWORM_BETTLE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(APItemInit.MILLIPEDE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("arthropocolypse", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder evenSimplerBlockItem(RegistryObject<Block> block) {
        return (ItemModelBuilder)this.withExistingParent("arthropocolypse:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    private ItemModelBuilder simpleItemWithSuffix(RegistryObject<Item> item, String suffix) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_() + "_" + suffix, new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("arthropocolypse", "item/" + item.getId().m_135815_() + "_" + suffix));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("arthropocolypse", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("arthropocolypse", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    private ModelFile.ExistingModelFile getModel(RegistryObject<?> item, String suffix) {
        return new ModelFile.ExistingModelFile(this.modLoc("item/" + item.getId().m_135815_() + "_" + suffix), this.existingFileHelper);
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "arthropocolypse";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + armorItem;
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = new ResourceLocation("arthropocolypse", armorItemPath);
                ResourceLocation trimResLoc = new ResourceLocation(trimPath);
                ResourceLocation trimNameResLoc = new ResourceLocation("arthropocolypse", currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", new ResourceLocation("arthropocolypse", "item/" + itemRegistryObject.getId().m_135815_()));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

