/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.entity;

import com.mojang.logging.LogUtils;
import dev.dh.arthropocolypse.entity.Scarab;
import dev.dh.arthropocolypse.init.APEntityInit;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.slf4j.Logger;

public class Behemoth_Desert_Spider
extends PathfinderMob {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Behemoth_Desert_Spider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int JUMP_ATTACK_COOLDOWN = 400;
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState dieAnimationState = new AnimationState();
    private int idleAnimationTimeoutTicks;
    private int attackAnimationTimeoutTicks = -1;
    private int jumpAttackTimeoutTicks = 400;
    private int jumpAttackTimeStopTicks;
    private int stunTimeoutTicks;
    private boolean isJumping;
    private boolean dropAfterDeathAnim;
    private int killDataRecentlyHit;
    private DamageSource killDataCause;
    private Player killDataAttackingPlayer;

    public Behemoth_Desert_Spider(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BehemothDesertSpiderJumpAttackGoal(this, 5.0f, 60, 0.7f));
        this.f_21345_.m_25352_(2, (Goal)new BehemothDesertSpiderAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new BehemothDesertSpiderMoveGoal(this, false, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, null));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 256.0).m_22268_(Attributes.f_22284_, 16.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22281_, 18.0).m_22268_(Attributes.f_22282_, 0.2).m_22268_(Attributes.f_22278_, 0.95).m_22268_(Attributes.f_22279_, 0.3);
    }

    public void m_7334_(Entity entity) {
        if (!this.m_21224_()) {
            super.m_7334_(entity);
        }
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.updateAnimationStates();
        } else if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 5.0f) {
            this.jumpAttackTimeoutTicks = Math.max(this.jumpAttackTimeoutTicks - 1, 0);
        }
        this.updateBossBar();
        if (this.m_5448_() != null) {
            this.f_21365_.m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
        }
    }

    private void updateBossBar() {
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    private void updateAnimationStates() {
        this.updateIdleAnimationState();
        this.updateAttackAnimationState();
    }

    private void updateIdleAnimationState() {
        if (this.idleAnimationTimeoutTicks <= 0) {
            this.idleAnimationTimeoutTicks = 40;
            if (this.f_20890_) {
                this.idleAnimationState.m_216973_();
            } else {
                this.idleAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            --this.idleAnimationTimeoutTicks;
        }
    }

    private void updateAttackAnimationState() {
        if (this.isAttacking() && this.attackAnimationTimeoutTicks <= 0) {
            this.attackAnimationTimeoutTicks = (int)(27.0 + 20.0 * this.m_21133_(Attributes.f_22283_));
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeoutTicks;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    private void updateJumpAttack() {
        if (this.stunTimeoutTicks > 0 && this.stunTimeoutTicks < 20) {
            this.m_20256_(new Vec3(0.0, this.m_20184_().f_82480_, 0.0));
            if (this.jumpAttackTimeStopTicks <= 0) {
                this.jumpAttackTimeStopTicks = this.attackAnimationTimeoutTicks;
            }
            this.attackAnimationTimeoutTicks = this.jumpAttackTimeStopTicks;
        } else {
            this.jumpAttackTimeStopTicks = -1;
        }
    }

    protected void m_267689_(float partialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void m_8107_() {
        super.m_8107_();
        this.updateMovement();
        this.updateJumpAttack();
    }

    private void updateMovement() {
        if (this.stunTimeoutTicks-- > 0) {
            this.m_20256_(new Vec3(0.0, this.m_20184_().f_82480_, 0.0));
        }
    }

    protected void m_6153_() {
        if (this.f_20919_ == 0) {
            this.m_20124_(Pose.DYING);
            this.m_146850_(GameEvent.f_223707_);
            this.dieAnimationState.m_216977_(this.f_19797_);
            this.m_21231_().m_19296_();
            if (this.m_5803_()) {
                this.m_5796_();
            }
        }
        ++this.f_20919_;
        if (this.f_20919_ % 10 == 4) {
            this.spawnScarabOnDeath();
        }
        if (this.f_20919_ >= 100 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.f_20888_ = this.killDataAttackingPlayer;
            this.f_20889_ = this.killDataRecentlyHit;
            if (!this.m_9236_().f_46443_ && this.dropAfterDeathAnim && this.killDataCause != null) {
                this.m_6668_(this.killDataCause);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void spawnScarabOnDeath() {
        Scarab scarab = new Scarab((EntityType<? extends PathfinderMob>)((EntityType)APEntityInit.SCARAB.get()), this.m_9236_());
        scarab.m_6034_(this.m_20185_(), Math.floor(this.m_20186_()), this.m_20189_());
        scarab.m_20256_(new Vec3((double)(this.f_19796_.m_188501_() * 2.0f - 1.0f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() * 2.0f - 1.0f)));
        scarab.m_6710_(this.m_5448_());
        for (int i = 0; i < 5; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), this.f_19796_.m_188583_() * 0.3, this.f_19796_.m_188583_() * 0.3, this.f_19796_.m_188583_() * 0.3);
        }
        this.m_9236_().m_7967_((Entity)scarab);
    }

    public void m_5997_(double p_20286_, double p_20287_, double p_20288_) {
        if (!this.m_21224_()) {
            super.m_5997_(p_20286_, p_20287_, p_20288_);
        }
    }

    public void m_6667_(DamageSource source) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        if (!this.f_20890_) {
            Entity entity = source.m_7639_();
            LivingEntity killedBy = this.m_21232_();
            if (this.f_20897_ >= 0 && killedBy != null) {
                killedBy.m_5993_((Entity)this, this.f_20897_, source);
            }
            if (!this.m_9236_().f_46443_ && this.m_8077_()) {
                LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.m_21231_().m_19293_().getString());
            }
            this.f_20890_ = true;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if ((entity == null || entity.m_214076_(serverLevel, (LivingEntity)this)) && !this.dropAfterDeathAnim) {
                    this.m_6668_(source);
                }
            }
            this.killDataCause = source;
            this.killDataRecentlyHit = this.f_20889_;
            this.killDataAttackingPlayer = this.f_20888_;
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(0.5 * (this.m_20186_() - this.f_19855_)), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 16.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    private static class BehemothDesertSpiderJumpAttackGoal
    extends Goal {
        private final Behemoth_Desert_Spider entity;
        private final float attackRange;
        private final int dashTicks;
        private final float jumpForce;
        private int leftTicks;

        public BehemothDesertSpiderJumpAttackGoal(Behemoth_Desert_Spider entity, float attackRange, int dashTicks, float jumpForce) {
            this.entity = entity;
            this.attackRange = attackRange;
            this.dashTicks = dashTicks;
            this.jumpForce = jumpForce;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackRange && this.entity.jumpAttackTimeoutTicks == 0;
        }

        public void m_8056_() {
            float f = this.entity.m_146908_() * ((float)Math.PI / 180);
            Vec3 vec3 = this.entity.m_20184_().m_82549_(new Vec3((double)Mth.m_14031_((float)f), 0.0, (double)(-Mth.m_14089_((float)f))).m_82541_().m_82490_(1.2));
            this.entity.m_20334_(vec3.f_82479_, this.jumpForce, vec3.f_82481_);
            this.leftTicks = -1;
            this.entity.jumpAttackTimeoutTicks = 400;
            this.entity.isJumping = true;
            this.entity.f_19862_ = false;
        }

        public void m_8041_() {
            this.entity.isJumping = false;
        }

        public boolean m_8045_() {
            return this.leftTicks != 0 && !this.entity.m_21224_();
        }

        public void m_8037_() {
            if (this.entity.m_20096_() && this.entity.m_5448_() != null) {
                if (this.leftTicks == -1) {
                    this.leftTicks = this.dashTicks;
                    this.entity.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.entity.m_20075_()), true, this.entity.m_20208_(2.0), this.entity.m_20186_(), this.entity.m_20262_(2.0), (double)(new Random().nextFloat(2.0f) - 1.0f), (double)(new Random().nextFloat() + 0.5f), (double)(new Random().nextFloat(2.0f) - 1.0f));
                }
                --this.leftTicks;
                if (this.leftTicks < this.dashTicks - 6) {
                    BlockPos navigatorPos = this.entity.m_21573_().m_26567_();
                    this.entity.m_21573_().m_26572_();
                    this.entity.m_21573_().m_26519_(this.entity.m_5448_().m_20185_(), this.entity.m_5448_().m_20186_(), this.entity.m_5448_().m_20189_(), this.entity.m_21051_(Attributes.f_22279_).m_22135_());
                    Vec3 vec3 = new Vec3((double)navigatorPos.m_123341_(), (double)navigatorPos.m_123342_(), (double)navigatorPos.m_123343_()).m_82546_(this.entity.m_20182_()).m_82541_().m_82490_(0.8);
                    this.entity.m_20334_(vec3.f_82479_, 0.0, vec3.f_82481_);
                    this.entity.f_21365_.m_24960_((Entity)this.entity.m_5448_(), 360.0f, 360.0f);
                    for (LivingEntity livingEntity : this.entity.m_9236_().m_45976_(LivingEntity.class, this.entity.m_20191_().m_82400_(1.2))) {
                        if (this.entity.m_7307_((Entity)livingEntity) || livingEntity instanceof Behemoth_Desert_Spider) continue;
                        boolean flag = livingEntity.m_6469_(this.entity.m_269291_().m_269333_((LivingEntity)this.entity), (float)this.entity.m_21133_(Attributes.f_22281_) * 0.4f);
                        if (flag) {
                            double d0 = livingEntity.m_20185_() - this.entity.m_20185_();
                            double d1 = livingEntity.m_20189_() - this.entity.m_20189_();
                            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                            Vec3 pushVector = new Vec3(d0 / d2, 0.0, d1 / d2).m_82541_();
                            livingEntity.m_5997_(pushVector.f_82479_, 1.0, pushVector.f_82481_);
                        }
                        this.leftTicks = 0;
                        this.entity.stunTimeoutTicks = 30;
                    }
                    if (this.entity.f_19862_) {
                        this.leftTicks = 0;
                        this.entity.stunTimeoutTicks = 30;
                    }
                }
            }
        }
    }

    private static class BehemothDesertSpiderAttackGoal
    extends MeleeAttackGoal {
        private final Behemoth_Desert_Spider entity;
        private int attackTick;

        public BehemothDesertSpiderAttackGoal(Behemoth_Desert_Spider mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)mob, speedModifier, followingTargetEvenIfNotSeen);
            this.entity = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean isEnemyInAttackDistance(LivingEntity enemy, double distToEnemySqr) {
            return distToEnemySqr < this.m_6639_(enemy);
        }

        protected void m_6739_(LivingEntity enemy, double dist) {
            if (this.attackTick > 30 && this.isEnemyInAttackDistance(enemy, dist) && enemy.m_6084_()) {
                this.attackTick = 0;
            }
            if (this.attackTick > 27 && this.isEnemyInAttackDistance(enemy, dist) && enemy.m_6084_()) {
                this.attackTick = (int)(-20.0 * this.entity.m_21133_(Attributes.f_22283_));
                this.entity.attackAnimationTimeoutTicks = -this.attackTick;
            }
            if (this.isEnemyInAttackDistance(enemy, dist - 2.0) && this.attackTick == 13) {
                this.performAttack(enemy, InteractionHand.MAIN_HAND);
            }
        }

        protected void performAttack(LivingEntity enemy, InteractionHand hand) {
            this.f_25540_.m_6674_(hand);
            this.f_25540_.m_7327_((Entity)enemy);
            this.f_25540_.m_21563_().m_148051_((Entity)enemy);
            enemy.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 20, 2), (Entity)this.f_25540_);
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.attackTick;
            this.entity.setAttacking(this.attackTick <= 27);
        }

        public void m_8056_() {
            this.attackTick = 0;
        }

        public void m_8041_() {
            this.entity.setAttacking(false);
        }
    }

    private static class BehemothDesertSpiderMoveGoal
    extends Goal {
        private final Behemoth_Desert_Spider monster;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private int delayCounter;
        private final double moveSpeed;

        public BehemothDesertSpiderMoveGoal(Behemoth_Desert_Spider boss, boolean followingTargetEvenIfNotSeen, double moveSpeed) {
            this.monster = boss;
            this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
            this.moveSpeed = moveSpeed;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity target = this.monster.m_5448_();
            return target != null && !target.m_21224_();
        }

        public void m_8041_() {
            LivingEntity livingEntity = this.monster.m_5448_();
            if (!EntitySelector.f_20406_.test(livingEntity)) {
                this.monster.m_6710_(null);
            }
            this.monster.m_21561_(false);
            this.monster.m_21573_().m_26573_();
        }

        public boolean m_8045_() {
            LivingEntity target = this.monster.m_5448_();
            if (target == null) {
                return false;
            }
            if (!target.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.monster.m_21573_().m_26571_();
            }
            if (!this.monster.m_21444_(target.m_20183_()) || this.monster.isJumping) {
                return false;
            }
            return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
        }

        public void m_8056_() {
            if (this.monster.m_5448_() != null && this.monster.m_20280_((Entity)this.monster.m_5448_()) < 30.0) {
                this.monster.m_21573_().m_5624_((Entity)this.monster, this.moveSpeed);
            }
            this.monster.m_21573_().m_26536_(this.path, this.moveSpeed);
            this.monster.m_21561_(true);
        }

        public void m_8037_() {
            LivingEntity target = this.monster.m_5448_();
            if (target != null) {
                this.monster.m_21563_().m_24960_((Entity)target, 360.0f, 360.0f);
                double distSq = this.monster.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
                if (--this.delayCounter <= 0) {
                    this.delayCounter = 4 + this.monster.m_217043_().m_188503_(7);
                    if (distSq > Math.pow(this.monster.m_21051_(Attributes.f_22277_).m_22135_(), 2.0)) {
                        if (!this.monster.m_21691_() && !this.monster.m_21573_().m_5624_((Entity)target, 1.0)) {
                            this.delayCounter += 5;
                        }
                    } else {
                        this.monster.m_21573_().m_5624_((Entity)target, this.moveSpeed);
                    }
                }
            }
        }
    }
}

