/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.entity;

import dev.dh.arthropocolypse.config.APConfig;
import dev.dh.arthropocolypse.entity.ai.ClimbableEntity;
import dev.dh.arthropocolypse.init.APItemInit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class Field_Cricket
extends ClimbableEntity {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState jumpAnimationState = new AnimationState();
    private int idleAnimationTimeOut;
    private int jumpDelay = new Random().nextInt(100) + 60;

    public Field_Cricket(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FieldCricketBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)APItemInit.CARROT_PIECE.get(), Items.f_42619_}), false));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.8f));
    }

    public static boolean checkFieldCricketSpawnRules(EntityType<? extends ClimbableEntity> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return spawnType == MobSpawnType.SPAWNER || Field_Cricket.m_217057_(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource) && (double)randomSource.m_188501_() < APConfig.fieldCricketSpawnChance;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22288_, 0.8).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected float m_6118_() {
        return super.m_6118_() * (new Random().nextFloat() * 3.0f + 1.0f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setUpAnimationStates();
        } else if (this.jumpDelay-- <= 0 && this.m_20096_()) {
            this.m_21569_().m_24901_();
            this.jumpDelay = new Random().nextInt(100) + 60;
        }
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    private void setUpAnimationStates() {
        if (this.m_20089_() == Pose.LONG_JUMPING) {
            this.jumpAnimationState.m_216977_(this.f_19797_);
        } else {
            this.jumpAnimationState.m_216973_();
        }
        if (this.idleAnimationTimeOut <= 0) {
            this.idleAnimationTimeOut = 60;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeOut;
        }
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(0.5 * (this.m_20186_() - this.f_19855_)), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 16.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public boolean m_6898_(ItemStack item) {
        return item.m_150930_(Items.f_42619_) || item.m_150930_((Item)APItemInit.CARROT_PIECE.get());
    }

    public void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    private static class FieldCricketBreedGoal
    extends BreedGoal {
        public FieldCricketBreedGoal(Animal p_25122_, double p_25123_) {
            super(p_25122_, p_25123_);
        }

        protected void m_8026_() {
            ItemEntity egg = new ItemEntity(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), new ItemStack((ItemLike)APItemInit.FIELD_CRICKET_EGG.get()));
            egg.m_20334_(0.0, (double)0.3f, 0.0);
            this.f_25114_.m_7967_((Entity)egg);
            this.f_25113_.m_146762_(6000);
            this.f_25115_.m_146762_(6000);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
        }
    }
}

