/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.entity;

import dev.dh.arthropocolypse.config.APConfig;
import dev.dh.arthropocolypse.entity.Stag_Beetle;
import dev.dh.arthropocolypse.init.APEntityInit;
import dev.dh.arthropocolypse.init.APItemInit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class Mealworm
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> BABY_TICK = SynchedEntityData.m_135353_(Mealworm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeOut;
    protected int forcedAgeTimer;

    public Mealworm(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    public static boolean checkMealwormSpawnRules(EntityType<? extends PathfinderMob> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return spawnType == MobSpawnType.SPAWNER || Mealworm.m_217057_(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource) && (double)randomSource.m_188501_() < APConfig.mealwormSpawnChance;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.1);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41619_()) {
            ItemStack larvaItem = new ItemStack((ItemLike)APItemInit.MEALWORM.get());
            player.m_21008_(hand, larvaItem);
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_150930_(Items.f_42410_) || player.m_21120_(hand).m_150930_(Items.f_42575_) || player.m_21120_(hand).m_150930_(Items.f_42619_) || player.m_21120_(hand).m_150930_((Item)APItemInit.CARROT_PIECE.get())) {
            if (this.forcedAgeTimer <= 0) {
                this.forcedAgeTimer = 5;
            }
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(hand).m_41774_(1);
            }
            this.setBabyTick(this.getBabyTick() - 1000);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            if (this.forcedAgeTimer > 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
            --this.forcedAgeTimer;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setUpAnimationStates();
        } else {
            this.setBabyTick(this.getBabyTick() - 1);
            if (this.getBabyTick() < 0) {
                Stag_Beetle beetle = new Stag_Beetle((EntityType<? extends PathfinderMob>)((EntityType)APEntityInit.MEALWORM_BEETLE.get()), this.m_9236_());
                beetle.m_20219_(this.m_20182_());
                beetle.m_20256_(this.m_20184_());
                this.m_5496_(SoundEvents.f_276434_, 0.5f, 0.5f);
                this.m_9236_().m_7967_((Entity)beetle);
                this.m_146870_();
            }
        }
    }

    private void setUpAnimationStates() {
        if (this.idleAnimationTimeOut <= 0) {
            this.idleAnimationTimeOut = 40;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeOut;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BABY_TICK, (Object)(20000 + new Random().nextInt(10000)));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Baby", this.getBabyTick());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBabyTick(compound.m_128451_("Baby"));
    }

    public int getBabyTick() {
        return (Integer)this.f_19804_.m_135370_(BABY_TICK);
    }

    public void setBabyTick(int tick) {
        this.f_19804_.m_135381_(BABY_TICK, (Object)tick);
    }
}

