/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.entity;

import dev.dh.arthropocolypse.config.APConfig;
import dev.dh.arthropocolypse.entity.Millipede_Body;
import dev.dh.arthropocolypse.init.APEntityInit;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class Millipede_Head
extends Monster {
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(Millipede_Head.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CHILD_ID = SynchedEntityData.m_135353_(Millipede_Head.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SEGMENT_COUNT = SynchedEntityData.m_135353_(Millipede_Head.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Millipede_Head.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final float[] ringBuffer = new float[64];
    public int ringBufferIndex = -1;
    private Millipede_Body[] parts;

    public Millipede_Head(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_21364_ = 20;
        this.m_274367_(3.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22277_, 22.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22279_, (double)0.22f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, false));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 1.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 1.0f, 1.0f);
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    public int m_21529_() {
        return 1;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHILD_ID, (Object)-1);
        this.f_19804_.m_135372_(SEGMENT_COUNT, (Object)12);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int i) {
        this.f_19804_.m_135381_(VARIANT, (Object)i);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                Difficulty difficulty = this.m_9236_().m_46791_();
                int i = difficulty == Difficulty.NORMAL ? 10 : (difficulty == Difficulty.HARD ? 20 : 3);
                if (this.getVariant() == 0) {
                    ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, i * 7, 1));
                }
            }
            this.m_146850_(GameEvent.f_223708_);
            return true;
        }
        return false;
    }

    public int getSegmentCount() {
        return Math.max((Integer)this.f_19804_.m_135370_(SEGMENT_COUNT), 1);
    }

    public void m_7334_(Entity entity) {
        if (!(entity instanceof Millipede_Body) && !(entity instanceof Millipede_Head)) {
            super.m_7334_(entity);
        }
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
        super.m_7601_(p_20006_, p_20007_);
    }

    public void setSegmentCount(int segments) {
        this.f_19804_.m_135381_(SEGMENT_COUNT, (Object)segments);
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public void m_6138_() {
        List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_(0.2, 0.0, 0.2));
        entities.stream().filter(entity -> !(entity instanceof Millipede_Body) && entity.m_6094_()).forEach(entity -> entity.m_7334_((Entity)this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setSegmentCount(this.f_19796_.m_188503_(5) + 8);
        if (worldIn.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_LUSH)) {
            this.setVariant(1);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getChildId() != null) {
            compound.m_128362_("ChildUUID", this.getChildId());
        }
        compound.m_128405_("SegCount", this.getSegmentCount());
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("ChildUUID")) {
            this.setChildId(compound.m_128342_("ChildUUID"));
        }
        this.setSegmentCount(compound.m_128451_("SegCount"));
        this.setVariant(compound.m_128451_("Variant"));
    }

    private boolean shouldReplaceParts() {
        if (this.parts == null || this.parts[0] == null || this.parts.length != this.getSegmentCount()) {
            return true;
        }
        for (int i = 0; i < this.getSegmentCount(); ++i) {
            if (this.parts[i] != null) continue;
            return true;
        }
        return false;
    }

    public static boolean checkMillipedeSpawnRules(EntityType<? extends Millipede_Head> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return spawnType == MobSpawnType.SPAWNER || Millipede_Head.m_217057_(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource) && (double)randomSource.m_188501_() < APConfig.millipedeSpawnChance && blockPos.m_123342_() <= APConfig.millipedeSpawnHeight;
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268671_) || super.m_6673_(source);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19817_ = false;
        this.f_20885_ = this.f_20883_ = Mth.m_14036_((float)this.m_146908_(), (float)(this.f_20883_ - 2.0f), (float)(this.f_20883_ + 2.0f));
        if (this.ringBufferIndex < 0) {
            Arrays.fill(this.ringBuffer, this.f_20883_);
        }
        if (this.updateRingBuffer() || this.ringBufferIndex < 0) {
            ++this.ringBufferIndex;
        }
        if (this.ringBufferIndex == this.ringBuffer.length) {
            this.ringBufferIndex = 0;
        }
        this.ringBuffer[this.ringBufferIndex] = this.m_146908_();
        if (!this.m_9236_().f_46443_) {
            int i;
            float backOffset;
            Entity child = this.getChild();
            if (child == null) {
                Object partParent = this;
                this.parts = new Millipede_Body[this.getSegmentCount()];
                Vec3 prevPos = this.m_20182_();
                backOffset = 0.25f;
                for (i = 0; i < this.getSegmentCount(); ++i) {
                    Millipede_Body part = this.createBody((LivingEntity)partParent, i == this.getSegmentCount() - 1);
                    part.setParent((Entity)partParent);
                    part.setBodyIndex(i);
                    if (partParent == this) {
                        this.setChildId(part.m_20148_());
                        this.f_19804_.m_135381_(CHILD_ID, (Object)part.m_19879_());
                    }
                    if (partParent instanceof Millipede_Body) {
                        Millipede_Body body = (Millipede_Body)partParent;
                        body.setChildId(part.m_20148_());
                    }
                    part.m_146884_(part.tickMultipartPosition(this.m_19879_(), backOffset, prevPos, this.m_146909_(), this.getYawForPart(i), false, true, this.getVariant()));
                    this.m_9236_().m_7967_((Entity)part);
                    this.parts[i] = part;
                    partParent = part;
                    backOffset = part.getBackOffset();
                    prevPos = part.m_20182_();
                }
            }
            if (this.f_19797_ > 1) {
                if (this.shouldReplaceParts() && this.getChild() instanceof Millipede_Body) {
                    this.parts = new Millipede_Body[this.getSegmentCount()];
                    this.parts[0] = (Millipede_Body)this.getChild();
                    this.f_19804_.m_135381_(CHILD_ID, (Object)this.parts[0].m_19879_());
                    for (int i2 = 1; i2 < this.parts.length && this.parts[i2 - 1].getChild() instanceof Millipede_Body; ++i2) {
                        this.parts[i2] = (Millipede_Body)this.parts[i2 - 1].getChild();
                    }
                }
                Vec3 prev = this.m_20182_();
                float xRot = this.m_146909_();
                backOffset = 0.45f;
                for (i = 0; i < this.getSegmentCount(); ++i) {
                    if (this.parts[i] == null) continue;
                    float reqRot = this.getYawForPart(i);
                    prev = this.parts[i].tickMultipartPosition(this.m_19879_(), backOffset, prev, xRot, reqRot, true, false, this.getVariant());
                    xRot = this.parts[i].m_146909_();
                    backOffset = this.parts[i].getBackOffset();
                }
            }
        }
    }

    private boolean updateRingBuffer() {
        return this.m_20184_().m_82556_() >= 0.005;
    }

    public Millipede_Body createBody(LivingEntity parent, boolean tail) {
        return tail ? new Millipede_Body((EntityType)APEntityInit.MILLIPEDE_TAIL.get(), parent, 0.3f, 180.0f, 0.0f) : new Millipede_Body((EntityType)APEntityInit.MILLIPEDE_BODY.get(), parent, 0.3f, 180.0f, 0.0f);
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    private float getYawForPart(int i) {
        return this.getRingBuffer(4 + i * 4, 1.0f);
    }

    public float getRingBuffer(int bufferOffset, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int j = this.ringBufferIndex - bufferOffset - 1 & 0x3F;
        float d1 = this.ringBuffer[j];
        int i = this.ringBufferIndex - bufferOffset & 0x3F;
        float d0 = this.ringBuffer[i];
        float angleDiff = Mth.m_14177_((float)(d1 - d0));
        if (Math.abs(angleDiff) > 180.0f) {
            d1 = angleDiff > 0.0f ? (d1 -= 360.0f) : (d1 += 360.0f);
        }
        float maxDelta = 1.0f;
        float targetAngle = d1;
        float currentAngle = d0;
        float diff = Mth.m_14177_((float)(targetAngle - currentAngle));
        float adjAngle = Mth.m_14177_((float)(currentAngle + Mth.m_14036_((float)diff, (float)(-maxDelta), (float)maxDelta)));
        return adjAngle;
    }
}

