/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.entity;

import dev.dh.arthropocolypse.config.APConfig;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class Platerodrilus
extends TamableAnimal
implements PlayerRideableJumping {
    private static final EntityDataAccessor<Byte> DATA_FLAG = SynchedEntityData.m_135353_(Platerodrilus.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(Platerodrilus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeOut;
    protected float playerJumpPendingScale;
    private boolean allowStandSliding;
    private int standCounter;
    protected boolean isJumping;

    public Platerodrilus(EntityType<? extends TamableAnimal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    public static boolean checkPlaterodrilusSpawnRules(EntityType<? extends TamableAnimal> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return spawnType == MobSpawnType.SPAWNER || Platerodrilus.m_217057_(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource) && (double)randomSource.m_188501_() < APConfig.platerodrilusSpawnChance;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22288_, 1.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAG, (Object)0);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Saddle", this.isSaddled());
    }

    public boolean m_6469_(DamageSource p_27567_, float p_27568_) {
        if (this.m_6673_(p_27567_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        return super.m_6469_(p_27567_, p_27568_);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSaddled(compound.m_128471_("Saddle"));
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setUpAnimationStates();
        }
        if ((this.m_6109_() || this.m_21515_()) && this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
            this.setStanding(false);
        }
        if (this.m_20096_() && this.isJumping()) {
            this.setIsJumping(false);
        }
    }

    public void m_7023_(Vec3 vec3) {
        super.m_7023_(vec3);
        if (this.m_6084_()) {
            LivingEntity livingEntity = this.m_6688_();
            if (this.m_20160_() && this.isSaddled() && livingEntity != null) {
                this.m_146922_(livingEntity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingEntity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.m_20096_()) {
                    double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + (double)this.m_285755_();
                    Vec3 deltaMovement = this.m_20184_();
                    this.m_20334_(deltaMovement.f_82479_, d1, deltaMovement.f_82481_);
                    this.setIsJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    this.playerJumpPendingScale = 0.0f;
                }
                this.m_267651_(false);
                this.m_146872_();
            } else {
                this.f_146794_ = 0.02f;
                super.m_7023_(vec3);
            }
        }
    }

    protected Vec3 m_274312_(Player p_278278_, Vec3 p_275506_) {
        if (this.m_20096_() && this.playerJumpPendingScale == 0.0f && this.isStanding() && !this.allowStandSliding) {
            return Vec3.f_82478_;
        }
        float f = p_278278_.f_20900_ * 0.5f;
        float f1 = p_278278_.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected float m_245547_(Player p_278336_) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    @javax.annotation.Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            return (Mob)entity;
        }
        if (this.isSaddled() && (entity = this.m_146895_()) instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        float ySin = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float yCos = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        pPassenger.m_6034_(this.m_20185_() + (double)(0.5f * ySin), this.m_20186_() + this.m_6048_() + pPassenger.m_6049_() - (double)0.1f, this.m_20189_() - (double)(0.5f * yCos));
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    public boolean isStanding() {
        return this.getFlag(32);
    }

    private boolean getFlag(int p_30648_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAG) & p_30648_) != 0;
    }

    public double m_6048_() {
        return 1.2;
    }

    public void m_7340_(Entity p_20320_) {
        if (this.m_6688_() != p_20320_) {
            this.clampRotation(p_20320_);
        }
    }

    private void clampRotation(Entity p_252070_) {
        p_252070_.m_5618_(this.m_146908_());
        float f = p_252070_.m_146908_();
        float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
        float f2 = Mth.m_14036_((float)f1, (float)-160.0f, (float)160.0f);
        p_252070_.f_19859_ += f2 - f1;
        float f3 = f + f2 - f1;
        p_252070_.m_146922_(f3);
        p_252070_.m_5616_(f3);
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean p_30656_) {
        this.isJumping = p_30656_;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (hand == InteractionHand.MAIN_HAND) {
            if (item == Items.f_42450_ && !this.isSaddled() && this.m_21824_()) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_216990_(SoundEvents.f_12466_);
                this.setSaddled(true);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() instanceof ShearsItem && this.isSaddled()) {
                this.m_216990_(SoundEvents.f_11688_);
                this.setSaddled(false);
                this.m_19998_((ItemLike)Items.f_42450_);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_204117_(ItemTags.f_13182_) && !this.m_21824_()) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            }
            if (!this.m_6898_(itemstack) && !player.m_6144_() && this.isSaddled()) {
                if (!this.m_9236_().f_46443_) {
                    player.m_20329_((Entity)this);
                    this.m_21839_(false);
                }
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(player, hand);
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player) && player.m_6144_()) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        return InteractionResult.PASS;
    }

    private void setUpAnimationStates() {
        if (this.idleAnimationTimeOut <= 0) {
            this.idleAnimationTimeOut = 40;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeOut;
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public void m_7888_(int p_30591_) {
        if (this.isSaddled()) {
            if (p_30591_ < 0) {
                p_30591_ = 0;
            } else {
                this.allowStandSliding = true;
                this.standIfPossible();
            }
            this.playerJumpPendingScale = p_30591_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_30591_ / 90.0f;
        }
    }

    public void standIfPossible() {
        if (this.m_6109_() && this.m_21515_()) {
            this.standCounter = 1;
            this.setStanding(true);
        }
    }

    public void setStanding(boolean p_30666_) {
        this.setFlag(32, p_30666_);
    }

    protected void setFlag(int p_30598_, boolean p_30599_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAG);
        if (p_30599_) {
            this.f_19804_.m_135381_(DATA_FLAG, (Object)((byte)(b0 | p_30598_)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAG, (Object)((byte)(b0 & ~p_30598_)));
        }
    }

    public boolean m_7132_() {
        return this.isSaddled();
    }

    public void m_7199_(int p_21695_) {
        this.allowStandSliding = true;
        this.standIfPossible();
    }

    public boolean m_6898_(ItemStack p_27600_) {
        Item item = p_27600_.m_41720_();
        return item.m_7968_().m_204117_(ItemTags.f_13182_);
    }

    public void m_8012_() {
    }

    private static class CustomRideGoal
    extends Goal {
        private final PathfinderMob tameableEntity;
        private LivingEntity player;
        private final double speed;

        public CustomRideGoal(PathfinderMob dragon, double speed) {
            this.tameableEntity = dragon;
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.tameableEntity.m_6688_() instanceof Player && this.tameableEntity.m_20160_()) {
                this.player = this.tameableEntity.m_6688_();
                return true;
            }
            this.tameableEntity.m_6858_(false);
            return false;
        }

        public void m_8056_() {
            this.tameableEntity.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.tameableEntity.m_274367_(1.0f);
            this.tameableEntity.m_21573_().m_26573_();
            this.tameableEntity.m_6710_(null);
            double x = this.tameableEntity.m_20185_();
            double y = this.tameableEntity.m_20186_();
            double z = this.tameableEntity.m_20189_();
            if (this.shouldMoveForward() && this.tameableEntity.m_20160_()) {
                Vec3 lookVec = this.player.m_20154_();
                if (this.shouldMoveBackwards()) {
                    lookVec = lookVec.m_82524_((float)Math.PI);
                }
                this.tameableEntity.m_21566_().m_6849_(x += lookVec.f_82479_ * 10.0, y += this.modifyYPosition(lookVec.f_82480_), z += lookVec.f_82481_ * 10.0, this.speed);
            }
        }

        public double modifyYPosition(double lookVecY) {
            return this.tameableEntity != null ? lookVecY * 10.0 : 0.0;
        }

        public boolean shouldMoveForward() {
            return this.player.f_20902_ != 0.0f;
        }

        public boolean shouldMoveBackwards() {
            return this.player.f_20902_ < 0.0f;
        }
    }
}

