/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.entity;

import dev.dh.arthropocolypse.config.APConfig;
import dev.dh.arthropocolypse.entity.Worker_Ant;
import dev.dh.arthropocolypse.entity.ai.ClimbableEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class Soldier_Ant
extends ClimbableEntity {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Soldier_Ant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    private int idleAnimationTimeOut;
    public int attackAnimationTimeOut;

    public Soldier_Ant(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    public static boolean checkSoldierAntSpawnRules(EntityType<? extends ClimbableEntity> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return spawnType == MobSpawnType.SPAWNER || Soldier_Ant.m_217057_(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource) && (double)randomSource.m_188501_() < APConfig.soldierAntSpawnChance;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new Soldier_Ant_Attack_Goal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{Worker_Ant.class}));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22283_, 0.5).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22282_, 0.4).m_22268_(Attributes.f_22278_, 0.4).m_22268_(Attributes.f_22279_, 0.3);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setUpAnimationStates();
        }
    }

    private void setUpAnimationStates() {
        if (this.idleAnimationTimeOut <= 0) {
            this.idleAnimationTimeOut = 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeOut;
        }
        if (this.isAttacking() && this.attackAnimationTimeOut <= 0) {
            this.attackAnimationTimeOut = 11 + (int)(20.0 * this.m_21133_(Attributes.f_22283_));
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeOut;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    protected void m_267689_(float partialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public class Soldier_Ant_Attack_Goal
    extends MeleeAttackGoal {
        private final Soldier_Ant entity;
        private int ticksUntilNextAttack;
        private boolean shouldCountTillNextAttack;

        public Soldier_Ant_Attack_Goal(PathfinderMob entity, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(entity, speedModifier, followingTargetEvenIfNotSeen);
            this.ticksUntilNextAttack = 8;
            this.shouldCountTillNextAttack = false;
            this.entity = (Soldier_Ant)entity;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.shouldCountTillNextAttack) {
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            }
        }

        protected void m_6739_(LivingEntity enemy, double distanceToEnemySqr) {
            if (this.isEnemyWithinAttackDistance(enemy, distanceToEnemySqr)) {
                this.shouldCountTillNextAttack = true;
                if (this.isTimeToStartAttackAnimaiton()) {
                    this.entity.setAttacking(true);
                }
                if (this.m_25564_()) {
                    this.f_25540_.m_21563_().m_24946_(enemy.m_20185_(), enemy.m_20188_(), enemy.m_20189_());
                    this.performAttack(enemy);
                }
            } else {
                this.m_25563_();
                this.shouldCountTillNextAttack = false;
                this.entity.setAttacking(false);
                this.entity.attackAnimationTimeOut = 0;
            }
        }

        private boolean isEnemyWithinAttackDistance(LivingEntity enemy, double distanceToEnemySqr) {
            return distanceToEnemySqr <= this.m_6639_(enemy);
        }

        protected void m_25563_() {
            this.ticksUntilNextAttack = this.m_183277_(11 + (int)(20.0 * this.entity.m_21133_(Attributes.f_22283_)));
        }

        protected boolean m_25564_() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected boolean isTimeToStartAttackAnimaiton() {
            return this.ticksUntilNextAttack <= 11;
        }

        protected int m_25565_() {
            return this.ticksUntilNextAttack;
        }

        protected void performAttack(LivingEntity enemy) {
            this.m_25563_();
            this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
            this.f_25540_.m_7327_((Entity)enemy);
        }

        public void m_8056_() {
            super.m_8056_();
            this.ticksUntilNextAttack = 11 + (int)(20.0 * this.entity.m_21133_(Attributes.f_22283_));
        }

        public void m_8041_() {
            this.entity.setAttacking(false);
            super.m_8041_();
        }
    }
}

