/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.entity;

import dev.dh.arthropocolypse.config.APConfig;
import dev.dh.arthropocolypse.entity.ai.ClimbableEntity;
import dev.dh.arthropocolypse.init.APItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Stag_Beetle
extends ClimbableEntity {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Stag_Beetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState flyAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    private int idleAnimationTimeOut;
    public int attackAnimationTimeOut;

    public Stag_Beetle(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    public static boolean checkStagBeetleSpawnRules(EntityType<? extends ClimbableEntity> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return spawnType == MobSpawnType.SPAWNER || Stag_Beetle.m_217057_(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource) && (double)randomSource.m_188501_() < APConfig.stagBeetleLarvaSpawnChance;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new Stag_Beetle_Attack_Goal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new StagBeetleBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_, Items.f_42575_}), false));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22278_, 0.4).m_22268_(Attributes.f_22279_, 0.2);
    }

    public boolean m_6898_(ItemStack item) {
        return item.m_150930_(Items.f_42410_) || item.m_150930_(Items.f_42575_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setUpAnimationStates();
        }
    }

    public boolean m_6573_(Player p_30151_) {
        return !this.m_5912_();
    }

    private void setUpAnimationStates() {
        if (this.idleAnimationTimeOut <= 0) {
            this.idleAnimationTimeOut = 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeOut;
        }
        if (this.isAttacking() && this.attackAnimationTimeOut <= 0) {
            this.attackAnimationTimeOut = 16 + (int)(20.0 * this.m_21133_(Attributes.f_22283_));
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeOut;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    protected void m_267689_(float partialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public static class Stag_Beetle_Attack_Goal
    extends MeleeAttackGoal {
        private final Stag_Beetle entity;
        private int ticksUntilNextAttack = 14;
        private boolean shouldCountTillNextAttack = false;

        public Stag_Beetle_Attack_Goal(PathfinderMob entity, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(entity, speedModifier, followingTargetEvenIfNotSeen);
            this.entity = (Stag_Beetle)entity;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.shouldCountTillNextAttack) {
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            }
        }

        protected void m_6739_(LivingEntity enemy, double distanceToEnemySqr) {
            if (this.isEnemyWithinAttackDistance(enemy, distanceToEnemySqr)) {
                this.shouldCountTillNextAttack = true;
                if (this.isTimeToStartAttackAnimaiton()) {
                    this.entity.setAttacking(true);
                }
                if (this.m_25564_()) {
                    this.f_25540_.m_21563_().m_24946_(enemy.m_20185_(), enemy.m_20188_(), enemy.m_20189_());
                    this.performAttack(enemy);
                }
            } else {
                this.m_25563_();
                this.shouldCountTillNextAttack = false;
                this.entity.setAttacking(false);
                this.entity.attackAnimationTimeOut = 0;
            }
        }

        private boolean isEnemyWithinAttackDistance(LivingEntity enemy, double distanceToEnemySqr) {
            return distanceToEnemySqr <= this.m_6639_(enemy);
        }

        protected void m_25563_() {
            this.ticksUntilNextAttack = this.m_183277_(16 + (int)(20.0 * this.entity.m_21133_(Attributes.f_22283_)));
        }

        protected boolean m_25564_() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected boolean isTimeToStartAttackAnimaiton() {
            return this.ticksUntilNextAttack <= 16;
        }

        protected int m_25565_() {
            return this.ticksUntilNextAttack;
        }

        protected void performAttack(LivingEntity enemy) {
            this.m_25563_();
            this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
            this.f_25540_.m_7327_((Entity)enemy);
        }

        public void m_8056_() {
            super.m_8056_();
            this.ticksUntilNextAttack = 16 + (int)(20.0 * this.entity.m_21133_(Attributes.f_22283_));
        }

        public void m_8041_() {
            this.entity.setAttacking(false);
            super.m_8041_();
        }
    }

    private static class StagBeetleBreedGoal
    extends BreedGoal {
        public StagBeetleBreedGoal(Animal p_25122_, double p_25123_) {
            super(p_25122_, p_25123_);
        }

        protected void m_8026_() {
            ItemEntity egg = new ItemEntity(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), new ItemStack((ItemLike)APItemInit.STAG_BEETLE_EGG.get()));
            egg.m_20334_(0.0, (double)0.3f, 0.0);
            this.f_25114_.m_7967_((Entity)egg);
            this.f_25113_.m_146762_(6000);
            this.f_25115_.m_146762_(6000);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
        }
    }
}

