/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.entity.ai;

import dev.dh.arthropocolypse.entity.ai.SmartClimbPathNavigator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClimbableEntity
extends Animal {
    private static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.m_135353_(ClimbableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(ClimbableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public float attachChangeProgress = 0.0f;
    public float prevAttachChangeProgress = 0.0f;
    public Direction prevAttachDir = Direction.DOWN;

    protected ClimbableEntity(EntityType type, Level level) {
        super(type, level);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new SmartClimbPathNavigator((Mob)this, worldIn);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21224_()) {
            return;
        }
        Vec3 vector3d = this.m_20184_();
        this.prevAttachChangeProgress = this.attachChangeProgress;
        if (this.attachChangeProgress > 0.0f) {
            this.attachChangeProgress -= 0.1f;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setBesideClimbableBlock(this.f_19862_ || this.f_19863_ && !this.m_20096_());
            if (this.m_20096_() || this.m_20072_() || this.m_20077_()) {
                this.setAttachedFace(Direction.DOWN);
            } else if (this.f_19863_) {
                this.setAttachedFace(Direction.UP);
            } else {
                Vec3 position = this.m_20182_();
                Direction closestDirection = Direction.DOWN;
                double closestDistance = 100.0;
                for (Direction direction : HORIZONTALS) {
                    BlockPos pos = new BlockPos(Mth.m_14107_((double)position.f_82479_), Mth.m_14107_((double)position.f_82480_), Mth.m_14107_((double)position.f_82481_));
                    BlockPos offsetPos = pos.m_121945_(direction);
                    Vec3 offset = Vec3.m_82512_((Vec3i)offsetPos);
                    if (!(closestDistance > position.m_82554_(offset)) || !this.m_9236_().m_46578_(offsetPos, (Entity)this, direction.m_122424_())) continue;
                    closestDistance = position.m_82554_(offset);
                    closestDirection = direction;
                }
                this.setAttachedFace(closestDirection);
            }
        }
        boolean flag = false;
        Direction attachmentFacing = this.getAttachmentFacing();
        if (attachmentFacing != Direction.DOWN) {
            if (attachmentFacing == Direction.UP) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 1.0, 0.0));
            } else {
                if (!this.f_19862_) {
                    Vec3 vec = Vec3.m_82528_((Vec3i)attachmentFacing.m_122436_());
                    this.m_20256_(this.m_20184_().m_82549_(vec.m_82541_().m_82542_((double)0.1f, (double)0.1f, (double)0.1f)));
                }
                if (!this.m_20096_() && vector3d.f_82480_ < 0.0) {
                    this.m_20256_(this.m_20184_().m_82542_(1.0, 0.2, 1.0));
                    flag = true;
                }
            }
        }
        if (attachmentFacing == Direction.UP) {
            this.m_20242_(true);
            this.m_20256_(vector3d.m_82542_(0.7, 1.0, 0.7));
        } else {
            this.m_20242_(false);
        }
        if (!flag && this.m_6147_()) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.4, 1.0));
        }
        if (this.prevAttachDir != attachmentFacing) {
            this.attachChangeProgress = 1.0f;
        }
        this.prevAttachDir = attachmentFacing;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0 && this.getAttachmentFacing() != Direction.DOWN;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("AttachFace", (byte)((Direction)this.f_19804_.m_135370_(ATTACHED_FACE)).m_122411_());
    }

    public void m_146922_(float p_146923_) {
        super.m_146922_(p_146923_);
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ATTACHED_FACE, (Object)Direction.m_122376_((int)compound.m_128445_("AttachFace")));
    }

    private void setAttachedFace(Direction direction) {
        this.f_19804_.m_135381_(ATTACHED_FACE, (Object)direction);
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.f_19804_.m_135370_(ATTACHED_FACE);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(ATTACHED_FACE, (Object)Direction.DOWN);
    }
}

