/*
 * Decompiled with CFR 0.152.
 */
package dev.dh.arthropocolypse.entity.projectile;

import dev.dh.arthropocolypse.init.APEntityInit;
import dev.dh.arthropocolypse.init.APItemInit;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class MandibleDagger
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(MandibleDagger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack daggerItem = new ItemStack((ItemLike)APItemInit.MANDIBLE_DAGGER.get());
    private boolean dealtDamage;
    private int bounceCount;
    private static final int MAX_BOUNCE_COUNT = 8;

    public MandibleDagger(EntityType<? extends MandibleDagger> p_37561_, Level p_37562_) {
        super(p_37561_, p_37562_);
    }

    public MandibleDagger(Level p_37569_, LivingEntity p_37570_, ItemStack p_37571_) {
        super((EntityType)APEntityInit.MANDIBLE_DAGGER.get(), p_37570_, p_37569_);
        this.daggerItem = p_37571_.m_41777_();
        this.f_19804_.m_135381_(ID_FOIL, (Object)p_37571_.m_41790_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        super.m_8119_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 p_37575_, Vec3 p_37576_) {
        return this.dealtDamage ? null : super.m_6351_(p_37575_, p_37576_);
    }

    protected void m_5790_(EntityHitResult p_37573_) {
        Entity hitEntity = p_37573_.m_82443_();
        Entity entity = p_37573_.m_82443_();
        float f = 8.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.daggerItem, (MobType)livingentity.m_6336_());
        }
        Entity owner = this.m_19749_();
        Entity entity1 = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)(entity1 == null ? this : entity1));
        SoundEvent soundevent = SoundEvents.f_144125_;
        entity.f_19802_ = 0;
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
            }
        }
        float f1 = 1.0f;
        this.m_5496_(soundevent, f1, 1.0f);
        ++this.bounceCount;
        this.daggerItem.m_41622_(1, (LivingEntity)owner, p_43414_ -> p_43414_.m_21166_(EquipmentSlot.MAINHAND));
        if (this.daggerItem.m_41619_()) {
            this.m_146870_();
        } else if (this.bounceCount < 8) {
            this.redirectToClosestEnemy(hitEntity);
        }
    }

    private void redirectToClosestEnemy(Entity hitEntity) {
        List nearbyEntities = this.m_9236_().m_6249_(hitEntity, hitEntity.m_20191_().m_82400_(24.0), e -> e instanceof LivingEntity && e != hitEntity && this.isEnemy((LivingEntity)e));
        if (!nearbyEntities.isEmpty()) {
            Entity closestEntity = nearbyEntities.stream().min(Comparator.comparingDouble(arg_0 -> ((Entity)hitEntity).m_20280_(arg_0))).orElse(null);
            Vec3 direction = closestEntity.m_146892_().m_82546_(this.m_20182_()).m_82490_(0.2);
            this.m_20334_(direction.f_82479_, direction.f_82480_ + (double)0.1f, direction.f_82481_);
            this.dealtDamage = false;
        } else {
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        }
    }

    private boolean isEnemy(LivingEntity entity) {
        Entity owner = this.m_19749_();
        if (entity instanceof Player || entity instanceof TamableAnimal && ((TamableAnimal)entity).m_21830_((LivingEntity)owner)) {
            return false;
        }
        return entity instanceof Mob;
    }

    protected boolean m_142470_(Player p_150196_) {
        return super.m_142470_(p_150196_) || this.m_36797_() && p_150196_.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.9f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    protected ItemStack m_7941_() {
        return this.daggerItem.m_41777_();
    }
}

