/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.client;

import com.bay4lly.photochat.PhotoChat;
import com.bay4lly.photochat.client.PhotoUploadTask;
import com.bay4lly.photochat.util.ImageUtils;
import com.bay4lly.photochat.util.Localization;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class FilePathInputScreen
extends class_437 {
    private final class_437 parent;
    private class_342 pathInput;
    private class_4185 sendButton;
    private class_2561 statusMessage = class_2561.method_43473();
    private GLFWDropCallback dropCallback;

    public FilePathInputScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"text.photochat.enter_photo_path"));
        this.parent = parent;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int widgetWidth = 300;
        int widgetHeight = 20;
        this.pathInput = new class_342(this.field_22793, centerX - widgetWidth / 2, centerY - 30, widgetWidth, widgetHeight, (class_2561)class_2561.method_43471((String)"text.photochat.file_path"));
        this.pathInput.method_1852("");
        this.pathInput.method_47404((class_2561)class_2561.method_43471((String)"text.photochat.enter_or_paste_path"));
        this.pathInput.method_1880(Integer.MAX_VALUE);
        this.method_37063((class_364)this.pathInput);
        this.pathInput.method_25365(true);
        this.sendButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"text.photochat.send_button"), button -> this.sendFile()).method_46434(centerX - 155, centerY + 10, 150, widgetHeight).method_46431();
        this.method_37063((class_364)this.sendButton);
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"text.photochat.cancel_button"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX + 5, centerY + 10, 150, widgetHeight).method_46431();
        this.method_37063((class_364)cancelButton);
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        this.dropCallback = new GLFWDropCallback(){

            public void invoke(long window, int count, long names) {
                PointerBuffer nameBuffer = MemoryUtil.memPointerBuffer((long)names, (int)count);
                for (int i = 0; i < count; ++i) {
                    String pathStr = MemoryUtil.memUTF8((long)nameBuffer.get(i));
                    File file = new File(pathStr);
                    if (!file.isDirectory()) {
                        FilePathInputScreen.this.pathInput.method_1852(file.getAbsolutePath());
                        FilePathInputScreen.this.setStatus((class_2561)class_2561.method_43471((String)"text.photochat.path_auto_filled").method_27692(class_124.field_1054));
                        continue;
                    }
                    FilePathInputScreen.this.setStatus((class_2561)class_2561.method_43471((String)"text.photochat.drop_folder_error").method_27692(class_124.field_1061));
                }
            }
        };
        GLFW.glfwSetDropCallback((long)windowHandle, (GLFWDropCallbackI)this.dropCallback);
    }

    public void method_25432() {
        super.method_25432();
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        GLFW.glfwSetDropCallback((long)windowHandle, null);
        if (this.dropCallback != null) {
            this.dropCallback.free();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.field_22790 / 2 - 60, 0xFFFFFF);
        int color = this.statusMessage.method_10866().method_10973() != null ? this.statusMessage.method_10866().method_10973().method_27716() : 0xFFFFFF;
        context.method_27534(this.field_22793, this.statusMessage, this.field_22789 / 2, this.field_22790 / 2 + 40, color);
        class_5250 infoText1 = class_2561.method_43471((String)"text.photochat.path_copying_instructions_windows").method_27692(class_124.field_1054);
        class_5250 infoText2 = class_2561.method_43471((String)"text.photochat.shift_right_click").method_27692(class_124.field_1080);
        class_5250 infoText3 = class_2561.method_43471((String)"text.photochat.copy_as_path").method_27692(class_124.field_1080);
        class_5250 infoText4 = class_2561.method_43471((String)"text.photochat.paste_with_ctrl_v").method_27692(class_124.field_1080);
        class_5250 infoText5 = class_2561.method_43471((String)"text.photochat.drag_file_directly").method_27692(class_124.field_1080);
        context.method_27534(this.field_22793, (class_2561)infoText1, this.field_22789 / 2, this.field_22790 / 2 + 70, 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)infoText2, this.field_22789 / 2, this.field_22790 / 2 + 85, 0xAAAAAA);
        context.method_27534(this.field_22793, (class_2561)infoText3, this.field_22789 / 2, this.field_22790 / 2 + 100, 0xAAAAAA);
        context.method_27534(this.field_22793, (class_2561)infoText4, this.field_22789 / 2, this.field_22790 / 2 + 115, 0xAAAAAA);
        context.method_27534(this.field_22793, (class_2561)infoText5, this.field_22789 / 2, this.field_22790 / 2 + 130, 0xAAAAAA);
        this.pathInput.method_25394(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile() {
        String path;
        String rawPath = this.pathInput.method_1882().trim();
        String string = path = rawPath.startsWith("\"") && rawPath.endsWith("\"") ? rawPath.substring(1, rawPath.length() - 1).trim() : rawPath;
        if (path.isEmpty()) {
            this.setStatus((class_2561)class_2561.method_43471((String)"photochat.error.file_not_found").method_27692(class_124.field_1061));
            return;
        }
        boolean isUrl = path.startsWith("http://") || path.startsWith("https://");
        File tempFile = null;
        File file = new File(path);
        try {
            if (isUrl) {
                try {
                    file = tempFile = this.downloadImageToTempFile(path);
                }
                catch (IOException e) {
                    PhotoChat.LOGGER.error(Localization.translate("log.photo.download_failed", path), (Throwable)e);
                    this.setStatus((class_2561)class_2561.method_43471((String)"photochat.error.download_failed").method_27692(class_124.field_1061));
                    if (tempFile != null && tempFile.exists()) {
                        try {
                            Files.deleteIfExists(tempFile.toPath());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
            if (!file.exists() || file.isDirectory()) {
                this.setStatus((class_2561)class_2561.method_43471((String)"photochat.error.file_not_found").method_27692(class_124.field_1061));
                return;
            }
            byte[] imageData = ImageUtils.readImage(file);
            new Thread(new PhotoUploadTask(imageData, file.getName())).start();
            this.setStatus((class_2561)class_2561.method_43471((String)"text.photochat.upload_started").method_27692(class_124.field_1060));
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }
        catch (IOException e) {
            PhotoChat.LOGGER.error(Localization.translate("log.photo.read_failed", path), (Throwable)e);
            this.setStatus((class_2561)class_2561.method_43471((String)"photochat.error.read_error").method_27692(class_124.field_1061));
        }
        catch (IllegalArgumentException e) {
            PhotoChat.LOGGER.warn(Localization.translate("log.photo.validation_failed", e.getMessage()));
            this.setStatus((class_2561)class_2561.method_43471((String)e.getMessage()).method_27692(class_124.field_1061));
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                try {
                    Files.deleteIfExists(tempFile.toPath());
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadImageToTempFile(String urlStr) throws IOException {
        String path;
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(true);
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(15000);
        conn.setRequestProperty("User-Agent", "PhotoChat/1.0 (Minecraft Mod)");
        conn.connect();
        int code = conn.getResponseCode();
        if (code < 200 || code >= 300) {
            throw new IOException("HTTP response: " + code);
        }
        String contentType = conn.getContentType();
        if (!(contentType != null && contentType.toLowerCase().startsWith("image/") || (path = url.getPath().toLowerCase()).endsWith(".png") || path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".gif") || path.endsWith(".webp"))) {
            throw new IOException("URL does not point to an image (content-type=" + contentType + ")");
        }
        Path temp = Files.createTempFile("photochat_dl_", ".tmp", new FileAttribute[0]);
        try (InputStream in = conn.getInputStream();){
            Files.copy(in, temp, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            conn.disconnect();
        }
        return temp.toFile();
    }

    private void setStatus(class_2561 message) {
        this.statusMessage = message;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        String clipboard;
        if ((modifiers & 2) != 0 && keyCode == 86 && (clipboard = class_310.method_1551().field_1774.method_1460()) != null && !clipboard.isEmpty()) {
            this.pathInput.method_1852(clipboard);
            this.setStatus((class_2561)class_2561.method_43471((String)"text.photochat.pasted").method_27692(class_124.field_1054));
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }
}

