/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;

@Environment(value=EnvType.CLIENT)
public class PhotoDownloader {
    private static final Map<String, DownloadSession> SESSIONS = new HashMap<String, DownloadSession>();

    public static void startDownload(String photoId, int totalChunks) {
        SESSIONS.put(photoId, new DownloadSession(totalChunks));
    }

    public static void receiveChunk(String photoId, int chunkIndex, byte[] data) {
        DownloadSession session = SESSIONS.get(photoId);
        if (session != null) {
            session.addChunk(chunkIndex, data);
        }
    }

    public static class_1011 finishDownload(String photoId) {
        DownloadSession session = SESSIONS.remove(photoId);
        if (session != null && session.isComplete()) {
            byte[] imageData = session.reassemble();
            try {
                return class_1011.method_4309((InputStream)new ByteArrayInputStream(imageData));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] finishDownloadRaw(String photoId) {
        DownloadSession session = SESSIONS.remove(photoId);
        if (session != null && session.isComplete()) {
            return session.reassemble();
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    private static class DownloadSession {
        private final int totalChunks;
        private final byte[][] chunks;
        private int receivedChunks = 0;

        DownloadSession(int totalChunks) {
            this.totalChunks = totalChunks;
            this.chunks = new byte[totalChunks][];
        }

        void addChunk(int index, byte[] data) {
            if (index >= 0 && index < this.totalChunks && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.receivedChunks;
            }
        }

        boolean isComplete() {
            return this.receivedChunks == this.totalChunks;
        }

        byte[] reassemble() {
            int totalSize = 0;
            for (byte[] chunk : this.chunks) {
                if (chunk == null) {
                    return null;
                }
                totalSize += chunk.length;
            }
            byte[] fullData = new byte[totalSize];
            int pos = 0;
            for (byte[] chunk : this.chunks) {
                System.arraycopy(chunk, 0, fullData, pos, chunk.length);
                pos += chunk.length;
            }
            return fullData;
        }
    }
}

