/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static byte[] readImage(File file) throws IOException {
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".gif")) {
            return Files.readAllBytes(file.toPath());
        }
        BufferedImage img = ImageIO.read(file);
        if (img == null) {
            throw new IOException("Unsupported image format");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", baos);
        return baos.toByteArray();
    }

    public static boolean isGif(byte[] data) {
        return data.length >= 6 && data[0] == 71 && data[1] == 73 && data[2] == 70 && data[3] == 56 && (data[4] == 55 || data[4] == 57) && data[5] == 97;
    }
}

