/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.coloredslimes.mixins;

import aquariusplayz.coloredslimes.ColoredParticleOptions;
import aquariusplayz.coloredslimes.ISlime;
import aquariusplayz.coloredslimes.ModSetup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.ConversionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Slime.class}, remap=false)
public abstract class SlimeMixin
extends Mob
implements ISlime {
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.defineId(Slime.class, (EntityDataSerializer)EntityDataSerializers.INT);

    @Shadow
    abstract int getSize();

    public SlimeMixin(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"}, cancellable=true)
    protected void defineSynchedData(SynchedEntityData.Builder p_394106_, CallbackInfo ci) {
        p_394106_.define(DATA_COLOR, (Object)ModSetup.DEFAULT_COLOR.getId());
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"}, cancellable=true)
    protected void addAdditionalSaveData(ValueOutput p_410356_, CallbackInfo ci) {
        p_410356_.store("Color", DyeColor.LEGACY_ID_CODEC, (Object)this.getColor());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"}, cancellable=true)
    protected void readAdditionalSaveData(ValueInput p_410043_, CallbackInfo ci) {
        this.setColor(p_410043_.read("Color", DyeColor.LEGACY_ID_CODEC).orElse(ModSetup.DEFAULT_COLOR));
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(DATA_COLOR)));
    }

    @Override
    public void setColor(DyeColor p_397248_) {
        this.entityData.set(DATA_COLOR, (Object)p_397248_.getId());
    }

    @Inject(at={@At(value="TAIL")}, method={"finalizeSpawn"}, cancellable=true)
    public void finalizeSpawn(ServerLevelAccessor p_33601_, DifficultyInstance p_33602_, EntitySpawnReason p_364449_, @Nullable SpawnGroupData p_33604_, CallbackInfoReturnable<SpawnGroupData> cir) {
        RandomSource randomsource = p_33601_.getRandom();
        int i = randomsource.nextInt(16);
        this.setColor(DyeColor.byId((int)i));
    }

    @Inject(at={@At(value="HEAD")}, method={"remove"}, cancellable=true)
    public void remove(Entity.RemovalReason p_149847_, CallbackInfo ci) {
        if (!((Slime)this instanceof MagmaCube) && this.getColor() != ModSetup.DEFAULT_COLOR && this.getColor() != null) {
            int i = this.getSize();
            if (!this.level().isClientSide() && i > 1 && this.isDeadOrDying()) {
                float f = this.getDimensions(this.getPose()).width();
                float f1 = f / 2.0f;
                int j = i / 2;
                int k = 2 + this.random.nextInt(3);
                PlayerTeam playerteam = this.getTeam();
                for (int l = 0; l < k; ++l) {
                    float f2 = ((float)(l % 2) - 0.5f) * f1;
                    float f3 = ((float)(l / 2) - 0.5f) * f1;
                    this.convertTo(((Slime)this).getType(), new ConversionParams(ConversionType.SPLIT_ON_DEATH, false, false, playerteam), EntitySpawnReason.TRIGGERED, p_405512_ -> {
                        p_405512_.setSize(j, true);
                        ((ISlime)p_405512_).setColor(this.getColor());
                        p_405512_.snapTo(this.getX() + (double)f2, this.getY() + 0.5, this.getZ() + (double)f3, this.random.nextFloat() * 360.0f, 0.0f);
                    });
                }
            }
            super.remove(p_149847_);
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getParticleType"}, cancellable=true)
    protected void getParticleType(CallbackInfoReturnable<ParticleOptions> cir) {
        if (!((Slime)this instanceof MagmaCube) && this.getColor() != ModSetup.DEFAULT_COLOR && this.getColor() != null) {
            cir.setReturnValue((Object)new ColoredParticleOptions(this.getColor().getTextColor(), 1.0f));
            cir.cancel();
        }
    }
}

