/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium._impl.test.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class TestSerializableRecipe
implements Recipe<CraftingInput> {
    public static Holder<RecipeSerializer<?>> SERIALIZER;
    public static Holder<RecipeType<?>> RECIPE_TYPE;
    public static final List<TestSerializableRecipe> RECIPES;
    public static final MapCodec<TestSerializableRecipe> CODEC;
    public Ingredient input;
    public ItemStack output;
    public Block block;

    public TestSerializableRecipe(Ingredient input, ItemStack output, Block block) {
        this.input = input;
        this.output = output;
        this.block = block;
        RECIPES.add(this);
    }

    public TestSerializableRecipe() {
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        return this.input.test(inv.getItem(0));
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output;
    }

    public ItemStack getToastSymbol() {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SERIALIZER.value();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RECIPE_TYPE.value();
    }

    public boolean isValid(ItemStack input, Block block) {
        return this.input.test(input) && this.block == block;
    }

    static {
        RECIPES = new ArrayList<TestSerializableRecipe>();
        new TestSerializableRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.OAK_SAPLING)}), new ItemStack((ItemLike)Items.STICK, 3), Blocks.STONE);
        new TestSerializableRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.DIRT)}), new ItemStack((ItemLike)Items.DIAMOND, 1), Blocks.DIRT);
        ItemStack pick = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE, 1);
        pick.setDamageValue(100);
        new TestSerializableRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.STONE)}), pick, Blocks.DIRT);
        CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(i -> i.input), (App)ItemStack.CODEC.fieldOf("output").forGetter(i -> i.output), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(i -> i.block)).apply((Applicative)in, TestSerializableRecipe::new));
    }
}

