/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network.locator;

import com.google.common.collect.Maps;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.LocatorType;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class LocatorFactory {
    private static final Map<String, LocatorType> LOCATOR_TYPES = Maps.newHashMap();

    public static void registerLocatorType(LocatorType locatorType) {
        if (!LOCATOR_TYPES.containsKey(locatorType.getName())) {
            LOCATOR_TYPES.put(locatorType.getName(), locatorType);
        } else {
            Titanium.LOGGER.error("Locator Type already registered for name {}", (Object)locatorType.getName());
        }
    }

    public static LocatorInstance readPacketBuffer(RegistryFriendlyByteBuf packetBuffer) {
        String name = packetBuffer.readUtf(64);
        LocatorType type = LOCATOR_TYPES.get(name);
        if (type != null) {
            LocatorInstance instance = type.createInstance();
            instance.fromBytes(packetBuffer);
            return instance;
        }
        return null;
    }

    public static void writePacketBuffer(RegistryFriendlyByteBuf buffer, LocatorInstance instance) {
        buffer.writeUtf(instance.getType().getName(), 64);
        instance.toBytes(buffer);
    }
}

