/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.mcreator.biodiverse.init.BiodiverseModEntities;
import net.mcreator.biodiverse.init.BiodiverseModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BelugaWhaleEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(BelugaWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(BelugaWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(BelugaWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private boolean isHostileToPlayer = false;
    private long lastSwing;
    public String animationprocedure = "empty";
    public float yawDelta = 0.0f;
    public float prevYawDelta = 0.0f;
    public float pitchValue = 0.0f;
    public float prevPitchValue = 0.0f;
    public float zTilt = 0.0f;
    public float prevZTilt = 0.0f;
    public float smoothedYaw = 0.0f;
    public float smoothedPitch = 0.0f;
    public float bodyPitch = 0.0f;
    public float prevBodyPitch = 0.0f;
    public float prevHeadYaw = 0.0f;
    public float prevBodyYaw = 0.0f;
    public float prevTailYaw = 0.0f;
    String prevAnim = "empty";

    public BelugaWhaleEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BelugaWhaleEntity>)((EntityType)BiodiverseModEntities.BELUGA_WHALE.get()), world);
    }

    public BelugaWhaleEntity(EntityType<BelugaWhaleEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(1.2f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevHeadYaw = this.f_20885_;
        this.prevBodyYaw = this.f_19859_;
        this.prevTailYaw = this.f_19859_;
        this.prevBodyPitch = this.bodyPitch;
        this.prevYawDelta = this.yawDelta;
        this.yawDelta = Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
        this.prevPitchValue = this.pitchValue;
        this.pitchValue = this.bodyPitch;
        this.prevZTilt = this.zTilt;
        List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(20.0));
        boolean bonded = false;
        for (Player player : players) {
            if (!player.m_21023_((MobEffect)BiodiverseModMobEffects.BELUGA_BOND.get())) continue;
            if (!this.m_21824_() || !player.m_20148_().equals(this.m_21805_())) {
                this.m_21828_(player);
            }
            bonded = true;
            break;
        }
        if (!bonded && this.m_21824_()) {
            this.m_21816_(null);
            this.m_7105_(false);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"beluga");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public boolean isHostileToPlayer() {
        return this.isHostileToPlayer;
    }

    public void setHostileToPlayer(boolean hostile) {
        this.isHostileToPlayer = hostile;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_() * entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new BelugaSwimWithPlayerGoal(1.2));
        this.f_21345_.m_25352_(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1){
            private final double maxDistanceXZ = 20.0;
            private final double maxDistanceY = 5.0;
            private final Random random;
            {
                this.maxDistanceXZ = 20.0;
                this.maxDistanceY = 5.0;
                this.random = new Random();
            }

            protected Vec3 m_7037_() {
                for (int attempt = 0; attempt < 10; ++attempt) {
                    double x = BelugaWhaleEntity.this.m_20185_() + this.random.nextDouble() * 2.0 * 20.0 - 20.0;
                    double y = BelugaWhaleEntity.this.m_20186_() + this.random.nextDouble() * 2.0 * 5.0 - 5.0;
                    double z = BelugaWhaleEntity.this.m_20189_() + this.random.nextDouble() * 2.0 * 20.0 - 20.0;
                    if (BelugaWhaleEntity.this.m_9236_().m_8055_(BelugaWhaleEntity.this.m_20183_().m_7918_((int)Math.floor(x - BelugaWhaleEntity.this.m_20185_()), (int)Math.floor(y - BelugaWhaleEntity.this.m_20186_()), (int)Math.floor(z - BelugaWhaleEntity.this.m_20189_()))).m_60734_() != Blocks.f_49990_) continue;
                    return new Vec3(x, y, z);
                }
                double x = BelugaWhaleEntity.this.m_20185_() + this.random.nextDouble() * 2.0 * 20.0 - 20.0;
                double y = BelugaWhaleEntity.this.m_20186_() + this.random.nextDouble() * 2.0 * 5.0 - 5.0;
                double z = BelugaWhaleEntity.this.m_20189_() + this.random.nextDouble() * 2.0 * 20.0 - 20.0;
                return new Vec3(x, y, z);
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.4f;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.beluga.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.beluga.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.beluga.hurt"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && source.m_7639_() instanceof Player) {
            this.setHostileToPlayer(true);
            List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(16.0));
            for (Player player : players) {
                player.m_21195_((MobEffect)BiodiverseModMobEffects.BELUGA_BOND.get());
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128379_("HostileToPlayer", this.isHostileToPlayer);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("HostileToPlayer")) {
            this.isHostileToPlayer = compound.m_128471_("HostileToPlayer");
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)3.0f, (float)1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        BelugaWhaleEntity retval = (BelugaWhaleEntity)((EntityType)BiodiverseModEntities.BELUGA_WHALE.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BiodiverseModEntities.BELUGA_WHALE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 2.0);
        builder = builder.m_22268_(Attributes.f_22276_, 25.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0);
        return builder;
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.HumpbackSwim"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20069_()) {
            boolean closeEnough = false;
            if (this.m_21573_().m_26572_()) {
                double dz;
                double dy;
                BlockPos targetPos = this.m_21573_().m_26567_();
                Vec3 target = new Vec3((double)targetPos.m_123341_() + 1.5, (double)targetPos.m_123342_() + 1.5, (double)targetPos.m_123343_() + 1.5);
                double dx = target.f_82479_ - this.m_20185_();
                double distanceSq = dx * dx + (dy = target.f_82480_ - this.m_20186_()) * dy + (dz = target.f_82481_ - this.m_20189_()) * dz;
                if (distanceSq < 9.0) {
                    closeEnough = true;
                    this.m_21573_().m_26573_();
                }
            }
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
            Vec3 motion = this.m_20184_();
            double horizontalSpeed = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_);
            float targetPitch = (float)(-Mth.m_14136_((double)motion.f_82480_, (double)horizontalSpeed)) * 57.295776f;
            targetPitch = Mth.m_14036_((float)targetPitch, (float)-25.0f, (float)25.0f);
            float pitchFactor = 1.0f;
            int maxCheck = 4;
            if (motion.f_82480_ > 0.0) {
                for (int i = 1; i <= maxCheck; ++i) {
                    BlockPos posAbove = this.m_20183_().m_6630_(i);
                    if (this.m_9236_().m_8055_(posAbove).m_60713_(Blocks.f_49990_)) continue;
                    pitchFactor = (float)i / (float)maxCheck;
                    break;
                }
            }
            if (motion.f_82480_ < 0.0) {
                for (int i = 1; i <= maxCheck; ++i) {
                    BlockPos posBelow = this.m_20183_().m_6625_(i);
                    if (this.m_9236_().m_8055_(posBelow).m_60713_(Blocks.f_49990_)) continue;
                    pitchFactor = Math.min(pitchFactor, (float)i / (float)maxCheck);
                    break;
                }
            }
            if (horizontalSpeed < 0.001 && Math.abs(motion.f_82480_) < 0.001) {
                pitchFactor = 0.0f;
            }
            this.smoothedPitch = Mth.m_14179_((float)0.1f, (float)this.smoothedPitch, (float)(targetPitch *= pitchFactor));
            this.m_146926_(this.smoothedPitch);
            this.prevBodyPitch = this.bodyPitch;
            this.bodyPitch = Mth.m_14179_((float)0.1f, (float)this.bodyPitch, (float)this.smoothedPitch);
            this.smoothedYaw = Mth.m_14179_((float)0.1f, (float)this.smoothedYaw, (float)this.m_146908_());
            this.prevZTilt = this.zTilt;
            if (!closeEnough) {
                float rawDeltaYaw = Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
                float clampedYaw = Mth.m_14036_((float)rawDeltaYaw, (float)-4.0f, (float)4.0f);
                float targetZTilt = Mth.m_14036_((float)(clampedYaw * -4.0f), (float)-50.0f, (float)50.0f);
                this.zTilt = Mth.m_14179_((float)0.15f, (float)this.zTilt, (float)targetZTilt);
            } else {
                this.zTilt = Mth.m_14179_((float)0.15f, (float)this.zTilt, (float)0.0f);
            }
            this.f_20883_ = this.m_146908_();
        } else {
            super.m_7023_(travelVector);
            this.prevZTilt = this.zTilt;
            this.zTilt = Mth.m_14179_((float)0.1f, (float)this.zTilt, (float)0.0f);
        }
    }

    private class BelugaSwimWithPlayerGoal
    extends Goal {
        private final double speedModifier;
        @Nullable
        private Player player;

        public BelugaSwimWithPlayerGoal(double speedModifier) {
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            TargetingConditions conditions = TargetingConditions.m_148353_().m_26883_(10.0).m_26888_(p -> p.m_6069_() && BelugaWhaleEntity.this.m_5448_() != p);
            this.player = BelugaWhaleEntity.this.m_9236_().m_45946_(conditions, (LivingEntity)BelugaWhaleEntity.this);
            return this.player != null;
        }

        public boolean m_8045_() {
            return this.player != null && this.player.m_6069_() && BelugaWhaleEntity.this.m_20280_((Entity)this.player) < 100.0;
        }

        public void m_8056_() {
            this.player.m_147207_(new MobEffectInstance((MobEffect)BiodiverseModMobEffects.BELUGA_BOND.get(), 200, 0, false, true), (Entity)BelugaWhaleEntity.this);
        }

        public void m_8041_() {
            this.player = null;
            BelugaWhaleEntity.this.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.player == null) {
                return;
            }
            BelugaWhaleEntity.this.m_21563_().m_24960_((Entity)this.player, (float)(BelugaWhaleEntity.this.m_8085_() + 20), (float)BelugaWhaleEntity.this.m_8132_());
            double distanceSq = BelugaWhaleEntity.this.m_20280_((Entity)this.player);
            if (distanceSq < 9.0) {
                BelugaWhaleEntity.this.m_21573_().m_26573_();
            } else {
                BelugaWhaleEntity.this.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
            }
            if (this.player.m_6069_() && this.player.m_9236_().f_46441_.m_188503_(10) == 0) {
                this.player.m_147207_(new MobEffectInstance((MobEffect)BiodiverseModMobEffects.BELUGA_BOND.get(), 200, 0, false, true), (Entity)BelugaWhaleEntity.this);
            }
        }
    }
}

